% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncPlotters.R
\name{plotSyncModelHydros}
\alias{plotSyncModelHydros}
\title{Plot hydrophone positions. Especially useful if some hydro re-positioned as part of the sync model.}
\usage{
plotSyncModelHydros(sync_model)
}
\arguments{
\item{sync_model}{Synchronization model obtained using \code{getSyncModel()}}
}
\value{
No return value, called to plot graphics.
}
\description{
Plot hydrophone positions. Especially useful if some hydro re-positioned as part of the sync model.
}
\examples{
\donttest{
sync_model <- ssu1$sync_model

plotSyncModelHydros(sync_model)

plotSyncModelResids(sync_model, by = "overall")
plotSyncModelResids(sync_model, by = "quantiles")
plotSyncModelResids(sync_model, by = "sync_tag")
plotSyncModelResids(sync_model, by = "hydro")
plotSyncModelResids(sync_model, by = "temporal")
plotSyncModelResids(sync_model, by = "temporal_hydro")
plotSyncModelResids(sync_model, by = "temporal_sync_tag")

plotSyncModelCheck(sync_model, by = "hydro")
plotSyncModelCheck(sync_model, by = "sync_tag")
plotSyncModelCheck(sync_model, by = "sync_bin_sync")
plotSyncModelCheck(sync_model, by = "sync_bin_hydro")
}
}
