% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_class.R
\name{mcc}
\alias{mcc}
\alias{mcc.data.frame}
\alias{mcc.table}
\alias{j_index}
\alias{j_index.data.frame}
\alias{j_index.table}
\title{Other Metrics for 2x2 Tables}
\usage{
mcc(data, ...)

\method{mcc}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

\method{mcc}{table}(data, ...)

j_index(data, ...)

\method{j_index}{data.frame}(data, truth, estimate, na.rm = TRUE, ...)

\method{j_index}{table}(data, ...)
}
\arguments{
\item{data}{For the default functions, a factor containing the
discrete measurements. For the \code{table} or \code{matrix}
functions, a table or matrix object, respectively, where the
true class results should be in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should an unquoted column name although
this argument is passed by expression and support
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names or column positions).}

\item{estimate}{The column identifier for the predicted class
results (that is also factor). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name.}

\item{na.rm}{A logical value indicating whether \code{NA}
values should be stripped before the computation proceeds}
}
\description{
General metrics for two class problems that are not already
in \code{\link[=sens]{sens()}} or \code{\link[=recall]{recall()}} are here, such as the Matthews
correlation coefficient, Youden's J.

There is no common convention on which factor level should
automatically be considered the "event" or "positive" results.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the last level of the factor is considered the
level of interest.
}
\details{
If more than one statistic is required, it is more
computationally efficient to create the confusion matrix using
\code{\link[=conf_mat]{conf_mat()}} and applying the corresponding \code{summary} method
(\code{\link[=summary.conf_mat]{summary.conf_mat()}}) to get the values at once.
}
\examples{
data("two_class_example")

mcc(two_class_example, truth, predicted)

j_index(two_class_example, truth, predicted)
}
\seealso{
\code{\link[=conf_mat]{conf_mat()}}, \code{\link[=summary.conf_mat]{summary.conf_mat()}}, \code{\link[=recall]{recall()}}, \code{\link[=sens]{sens()}}
}
\author{
Max Kuhn
}
