% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yesno2.R
\name{yesno2}
\alias{yesno2}
\title{Yes No with Two Custom Responses}
\usage{
yesno2(..., yes = "Yes", no = "No")
}
\arguments{
\item{...}{Objects to paste and then output to produce the question.}

\item{yes}{A string of the first response.}

\item{no}{A string of the second response.}
}
\value{
A flag indicating whether the user selected the first (TRUE) or second (FALSE) response.
}
\description{
Asks a custom yes-no question with two responses (by default 'Yes' or 'No').
Returns a flag indicating which response the user choose.
It is designed to be used in situations where a user needs to choose
one of two affirmative options.
}
\details{
The objects are first pasted without separators
and collapsed using \code{\link{paste0}(..., collapse = "")}
before being output using \code{\link{cat}}.

Selection of a 0 (to exit) causes the code to throw an error.
}
\examples{
\dontrun{
yesno2("Do you like this question?", yes = "I really do")
}
}
\seealso{
\code{\link{yesno}}
}
