% Generated by roxygen2 (4.0.0): do not edit by hand
\name{yhat.deploy.with.scp}
\alias{yhat.deploy.with.scp}
\title{Deploy a model via SCP. For when you want to automate large model uploads.}
\usage{
yhat.deploy.with.scp(model_name, pem_path)
}
\arguments{
\item{model_name}{name of your model}

\item{pem_path}{path to your aws .pem file}
}
\description{
For when you have a really big model file and you don't want to mess with
uploading it via the admin console.
This is useful for larger models (>20 MB).
}
\examples{
yhat.config <- c(
 username = "your username",
 apikey = "your apikey",
 env = "http://google.yhathq.com/"
)
iris$Sepal.Width_sq <- iris$Sepal.Width^2
fit <- glm(I(Species)=="virginica" ~ ., data=iris)

model.require <- function() {
 # require("randomForest")
}

model.transform <- function(df) {
 df$Sepal.Width_sq <- df$Sepal.Width^2
 df
}
model.predict <- function(df) {
 data.frame("prediction"=predict(fit, df, type="response"))
}
yhat.deploy.with.scp("irisModel", "~/path/to/pemfile.pem")
}
\keyword{deploy}

