% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yhatR.R
\name{yhat.library}
\alias{yhat.library}
\title{Import one or more libraries and add them to the Yhat model's
dependency list}
\usage{
yhat.library(name, src = "CRAN", version = NULL, user = NULL,
  install = TRUE)
}
\arguments{
\item{name}{name of the package to be added}

\item{src}{source from which the package will be installed on ScienceOps (github or CRAN)}

\item{version}{version of the package to be added}

\item{user}{Github username associated with the package}

\item{install}{Whether the package should also be installed into the model on the
ScienceOps server; this is typically set to False when the package has already been
added to the ScienceOps base image.}
}
\description{
Import one or more libraries and add them to the Yhat model's
dependency list
}
\examples{
\dontrun{
yhat.library("MASS")
yhat.library(c("wesanderson", "stringr"))
yhat.library("cats", src="github", user="hilaryparker")
yhat.library("hilaryparker/cats")
yhat.library("my_proprietary_package", install=FALSE)
}
}
\keyword{import}

