% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zalpha_all.R
\name{Zalpha_all}
\alias{Zalpha_all}
\title{Runs all the statistics in the zalpha package}
\usage{
Zalpha_all(
  pos,
  ws,
  x = NULL,
  dist = NULL,
  LDprofile_bins = NULL,
  LDprofile_rsq = NULL,
  LDprofile_sd = NULL,
  LDprofile_Beta_a = NULL,
  LDprofile_Beta_b = NULL,
  minRandL = 4,
  minRL = 25,
  X = NULL
)
}
\arguments{
\item{pos}{A numeric vector of SNP locations}

\item{ws}{The window size which the statistics will be calculated over. This should be on the same scale as the \code{pos} vector.}

\item{x}{Optional. A matrix of SNP values. Columns represent chromosomes; rows are SNP locations. Hence, the number of rows should equal the length of the \code{pos} vector. SNPs should all be biallelic.}

\item{dist}{Optional. A numeric vector of genetic distances (e.g. cM, LDU). This should be the same length as \code{pos}.}

\item{LDprofile_bins}{Optional. A numeric vector containing the lower bound of the bins used in the LD profile. These should be of equal size.}

\item{LDprofile_rsq}{Optional. A numeric vector containing the expected \eqn{r^2}{r^2} values for the corresponding bin in the LD profile. Must be between 0 and 1.}

\item{LDprofile_sd}{Optional. A numeric vector containing the standard deviation of the \eqn{r^2}{r^2} values for the corresponding bin in the LD profile.}

\item{LDprofile_Beta_a}{Optional. A numeric vector containing the first estimated Beta parameter for the corresponding bin in the LD profile.}

\item{LDprofile_Beta_b}{Optional. A numeric vector containing the second estimated Beta parameter for the corresponding bin in the LD profile.}

\item{minRandL}{Minimum number of SNPs in each set R and L for the statistics to be calculated. Default is 4.}

\item{minRL}{Minimum value for the product of the set sizes for R and L. Default is 25.}

\item{X}{Optional. Specify a region of the chromosome to calculate the statistics for in the format \code{c(startposition, endposition)}. The start position and the end position should be within the extremes of the positions given in the \code{pos} vector. If not supplied, the function will calculate the statistics for every SNP in the \code{pos} vector.}
}
\value{
A list containing the SNP positions and the statistics for those SNPs
}
\description{
Returns every statistic for each SNP location, given the appropriate parameters. See Details for more information.
}
\details{
Not all statistics will be returned, depending on the parameters supplied to the function.\cr
If \code{x} is not supplied, only \code{\link{Zalpha_expected}}, \code{\link{Zbeta_expected}}, \code{\link{LR}} and \code{\link{L_plus_R}} will be calculated.\cr
For any of the statistics which use an expected \eqn{r^2}{r^2} value, the parameters \code{dist}, \code{LDprofile_bins} and \code{LDprofile_rsq} must be supplied.
This includes the statistics: \code{\link{Zalpha_expected}}, \code{\link{Zalpha_rsq_over_expected}}, \code{\link{Zalpha_log_rsq_over_expected}}, \code{\link{Zalpha_Zscore}}, \code{\link{Zalpha_BetaCDF}}, \code{\link{Zbeta_expected}}, \code{\link{Zbeta_rsq_over_expected}}, \code{\link{Zbeta_log_rsq_over_expected}}, \code{\link{Zbeta_Zscore}} and \code{\link{Zbeta_BetaCDF}}.
\itemize{
  \item For \code{\link{Zalpha_Zscore}} and \code{\link{Zbeta_Zscore}} to be calculated, the parameter \code{LDprofile_sd} must also be supplied.
  \item For \code{\link{Zalpha_BetaCDF}} and \code{\link{Zbeta_BetaCDF}} to be calculated, the parameters \code{LDprofile_Beta_a} and \code{LDprofile_Beta_b} must also be supplied.
}
For more information about the statistics, please see Jacobs (2016).
}
\examples{
## load the snps and LDprofile example datasets
data(snps)
data(LDprofile)
## run Zalpha_all over all the SNPs with a window size of 3000 bp
## will return all 15 statistics
Zalpha_all(snps$positions,3000,as.matrix(snps[,3:12]),snps$distances,
 LDprofile$bin,LDprofile$rsq,LDprofile$sd,LDprofile$Beta_a,LDprofile$Beta_b)
## only return results for SNPs between locations 600 and 1500 bp
Zalpha_all(snps$positions,3000,as.matrix(snps[,3:12]),snps$distances,
 LDprofile$bin,LDprofile$rsq,LDprofile$sd,LDprofile$Beta_a,LDprofile$Beta_b,X=c(600,1500))
## will only return statistics not requiring an LD profile
Zalpha_all(snps$positions,3000,as.matrix(snps[,3:12]))

}
\references{
Jacobs, G.S., T.J. Sluckin, and T. Kivisild, \emph{Refining the Use of Linkage Disequilibrium as a Robust Signature of Selective Sweeps.} Genetics, 2016. \strong{203}(4): p. 1807
}
\seealso{
\code{\link{Zalpha}} \code{\link{Zalpha_expected}} \code{\link{Zalpha_rsq_over_expected}} \code{\link{Zalpha_log_rsq_over_expected}} \code{\link{Zalpha_Zscore}} \code{\link{Zalpha_BetaCDF}} \code{\link{Zbeta}} \code{\link{Zbeta_expected}} \code{\link{Zbeta_rsq_over_expected}} \code{\link{Zbeta_log_rsq_over_expected}} \code{\link{Zbeta_Zscore}} \code{\link{Zbeta_BetaCDF}} \code{\link{LR}} \code{\link{L_plus_R}}
}
