% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aab-periodogram-methods.R, R/ac-periodogram.R,
%   R/chi-sq-periodogram.R, R/fourier-periodogram.R, R/ls-periodogram.R
\name{periodogram_methods}
\alias{periodogram_methods}
\alias{ac_periodogram}
\alias{chi_sq_periodogram}
\alias{fourier_periodogram}
\alias{ls_periodogram}
\title{Methods For Computing Periodograms}
\usage{
ac_periodogram(x, period_range = c(hours(16), hours(32)),
  sampling_rate = 1/mins(1), alpha = 0.05)

chi_sq_periodogram(x, period_range = c(hours(16), hours(32)),
  sampling_rate = 1/mins(1), alpha = 0.05, time_resolution = hours(0.1))

fourier_periodogram(x, period_range = c(hours(16), hours(32)),
  sampling_rate = 1/mins(1), alpha = 0.05)

ls_periodogram(x, period_range = c(hours(16), hours(32)),
  sampling_rate = 1/mins(1), alpha = 0.05, oversampling = 8)
}
\arguments{
\item{x}{numeric vector}

\item{period_range}{vector of size 2 defining minimal and maximal range of period to study (in seconds)}

\item{sampling_rate}{the -- implicitly regular -- sampling rate of x (in hertz)}

\item{alpha}{significance level}

\item{time_resolution}{the resolution of periods to scan}

\item{oversampling}{the oversampling factor (see \link[lomb:lsp]{lomb::lsp})}
}
\value{
a \link{data.table} with the columns:
\itemize{
\item \code{period} -- the period (in s)
\item \code{power} -- the power (or equivalent) for a given period
\item \code{p_value} -- the significance of the power
\item \code{signif_threshold} -- the significance threshold of the power (at alpha)
}
}
\description{
These functions provides a series of methods to assess periodicity of circadian processes.
}
\references{
\itemize{
\item \href{https://rethomics.github.io/zeitgebr.html}{zeitgebr tutorial} -- the relevant rehtomics tutorial
}
}
\seealso{
\itemize{
\item \link[lomb:lsp]{lomb::lsp}  -- the orginal function for \code{ls_periodogram}
\item \link[xsp:chiSqPeriodogram]{xsp::chiSqPeriodogram} -- code modified from
\item \link[stats:acf]{stats::acf} -- the orginal function for \code{ac_periodogram}
}
}
