% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZenodoManager.R
\docType{class}
\name{ZenodoManager}
\alias{ZenodoManager}
\title{ZenodoManager}
\format{\code{\link{R6Class}} object.}
\usage{
ZenodoManager
}
\value{
Object of \code{\link{R6Class}} for modelling an ZenodoManager
}
\description{
ZenodoManager
}
\note{
Main user class to be used with \pkg{zen4R}
}
\section{Methods}{

\describe{
 \item{\code{new(url, token, logger)}}{
   This method is used to instantiate an ZenodoManager. By default,
   the url is set to "https://zenodo.org/api". The token is
   mandatory in order to use Zenodo API. The logger can be either
   NULL, "INFO" (with minimum logs), or "DEBUG" (for complete curl 
   http calls logs)
 }
 \item{\code{getLicenses(pretty)}}{
   Get the list of licenses. By default the argument \code{pretty} is set to 
   \code{TRUE} which will returns the list of licenses as \code{data.frame}.
   Set \code{pretty = FALSE} to get the raw list of licenses.
 }
 \item{\code{getLicenseById(id)}}{
   Get license by Id
 }
 \item{\code{getCommunities(pretty)}}{
   Get the list of communities. By default the argument \code{pretty} is set to 
   \code{TRUE} which will returns the list of communities as \code{data.frame}.
   Set \code{pretty = FALSE} to get the raw list of communities.
 }
 \item{\code{getCommunityById(id)}}{
   Get community by Id
 }
 \item{\code{getDepositions()}}{
   Get the list of Zenodo records deposited in your Zenodo workspace
 }
 \item{\code{depositRecord(record, publish)}}{
   A method to deposit/update a Zenodo record. The record should be an object
   of class \code{ZenodoRecord}. The method returns the deposited record
   of class \code{ZenodoRecord}. The parameter \code{publish} (default value
   is \code{FALSE}) can be set to \code{TRUE} (to use CAUTIOUSLY, only if you
   want to publish your record)
 }
 \item{\code{deleteRecord(recordId)}}{
   Deletes a Zenodo record based on its identifier.
 }
 \item{\code{deleteRecords()}}{
   Deletes all Zenodo deposited (unpublished) records.
 }
 \item{\code{createEmptyRecord()}}{
   Creates an empty record in the Zenodo deposit. Returns the record
   newly created in Zenodo, as an object of class \code{ZenodoRecord}
   with an assigned identifier.
 }
 \item{\code{publishRecord(recordId)}}{
   Publishes a deposited record online.
 }
 \item{\code{getFiles(recordId)}}{
   Get the list of uploaded files for a deposited record
 }
 \item{\code{uploadFile(path, recordId)}}{
   Uploads a file for a given Zenodo deposited record
 }
 \item{\code{deleteFile(recordId, fileId)}}{
   Deletes a file for a given Zenodo deposited record
 }
}
}

\examples{
\dontrun{
  ZENODO <- ZenodoManager$new(
     url = "https://sandbox.zenodo.org/api",
     token = "<your_token>",
     logger = "INFO"
  )
  
  #create (deposit) an empty record
  newRec <- ZENODO$createEmptyRecord()
  
  #create and fill a local (not yet deposited) record
  myrec <- ZenodoRecord$new()
  myrec$setTitle("my R package")
  myrec$setDescription("A description of my R package")
  myrec$setUploadType("software")
  myrec$addCreator(
    firstname = "John", lastname = "Doe",
    affiliation = "Independent", orcid = "0000-0000-0000-0000"
   )
  myrec$setLicense("mit")
  myrec$setAccessRight("open")
  myrec$setDOI("mydoi") #use this method if your DOI has been assigned elsewhere, outside Zenodo
  myrec$addCommunity("ecfunded")
  
  #deposit the record 
  myrec <- ZENODO$depositRecord(myrec)
  
  #publish a record (with caution!!)
  #this method will PUBLISH the deposition done earlier
  ZENODO$publishRecord(myrec$id)
  #With even more caution the publication can be done with a shortcut argument at deposit time
  ZENODO$depositRecord(myrec, publish = TRUE)
  
  #delete a record (by id)
  #this methods only works for unpublished deposits 
  #(if a record is published, it cannot be deleted anymore!)
  ZENODO$deleteRecord(myrec$id)
  
  #HOW TO UPLOAD FILES to a deposit
  
  #upload a file
  ZENODO$uploadFile("path/to/your/file", myrec$id)
  
  #list files
  zen_files <- ZENODO$getFiles(myrec$id)
  
  #delete a file?
  ZENODO$deleteFile(myrec$id, zen_files[[1]]$id)
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{manager}
\keyword{zenodo}
