% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dloon.R
\name{rect_2d_loon}
\alias{rect_2d_loon}
\title{Rectangle plot in 2d using the interactive loon package}
\usage{
rect_2d_loon(zargs, loc.x = NULL, loc.y = NULL, color = NULL,
  fill = NULL, lwd = 1, linkingGroup = NULL, showLabels = FALSE,
  showScales = FALSE, showGuides = FALSE, baseplot = NULL,
  parent = NULL, group... = NULL, ...)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{loc.x}{x-location of rectangle}

\item{loc.y}{y-location of rectangle}

\item{color}{Colour of the rectangle outline}

\item{fill}{Colour of the rectangle interior}

\item{lwd}{line width for rectangle outline}

\item{linkingGroup}{The initial linking group (ignored)}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines are displayed}

\item{baseplot}{If non-null the base plot on which the plot should be layered}

\item{parent}{The tk parent for this loon plot widget}

\item{group...}{A list of arguments passed to group_2d_loon (or NULL)}

\item{...}{Additional parameters passed to loon::l_layer_text(...)}
}
\value{
The base loon::l_plot with the added text layer
}
\description{
Rectangle plot in 2d using the interactive loon package
}
\seealso{
Other default 2d plot functions using the interactive loon package: \code{\link{arrow_2d_loon}},
  \code{\link{axes_2d_loon}},
  \code{\link{density_2d_loon}},
  \code{\link{group_2d_loon}}, \code{\link{label_2d_loon}},
  \code{\link{points_2d_loon}}

Other default 2d plot functions: \code{\link{arrow_2d_graphics}},
  \code{\link{arrow_2d_grid}}, \code{\link{arrow_2d_loon}},
  \code{\link{axes_2d_graphics}},
  \code{\link{axes_2d_grid}}, \code{\link{axes_2d_loon}},
  \code{\link{density_2d_graphics}},
  \code{\link{density_2d_grid}},
  \code{\link{density_2d_loon}}, \code{\link{extract_2d}},
  \code{\link{group_2d_graphics}},
  \code{\link{group_2d_grid}}, \code{\link{group_2d_loon}},
  \code{\link{label_2d_graphics}},
  \code{\link{label_2d_grid}}, \code{\link{label_2d_loon}},
  \code{\link{points_2d_graphics}},
  \code{\link{points_2d_grid}},
  \code{\link{points_2d_loon}},
  \code{\link{qq_2d_graphics}}, \code{\link{qq_2d_grid}},
  \code{\link{rect_2d_graphics}},
  \code{\link{rect_2d_grid}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the interactive loon package}
