% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_learn3.R
\name{dist_learn3}
\alias{dist_learn3}
\title{Distributed learning for a longitudinal continuous-time zero-inflated Poisson
hidden Markov model, where zero-inflation only happens in State 1 with covariates 
in the state-dependent parameters and transition rates.}
\usage{
dist_learn3(ylist, xlist, timelist, M, initparm, yceil = NULL, rho = 1,
  priorclust = NULL, tpmclust = NULL, tpmslopeclust = NULL,
  emitclust = NULL, zeroclust = NULL, slopeclust = NULL, group,
  maxit = 100, tol = 1e-04, ncores = 1, seed = 0,
  method = "Nelder-Mead", print = TRUE, libpath = NULL, ...)
}
\arguments{
\item{ylist}{list of observed time series values for each subject}

\item{xlist}{list of design matrices for each subject.}

\item{timelist}{list of time indices}

\item{M}{number of latent states}

\item{initparm}{matrix of initial working parameters for prior, transition, 
zero proportion, and emission parameters.}

\item{yceil}{a scalar defining the ceiling of y, above which the values will be
truncated. Default to NULL.}

\item{rho}{tuning parameter in the distributed learning algorithm. Default
to 1.}

\item{priorclust}{a vector to specify the grouping for state prior. Default to
NULL, which means no grouping.}

\item{tpmclust}{a vector to specify the grouping for the intercepts in state 
transition rates. Default to NULL, which means no grouping.}

\item{tpmslopeclust}{a vector to specify the grouping for the slopes in state 
transition rates. Default to NULL, which means no grouping.}

\item{emitclust}{a vector to specify the grouping for the intercepts in Poisson
regressions. Default to NULL, which means no grouping.}

\item{zeroclust}{a vector to specify the grouping for the intercepts in ZIP 
regression. Default to NULL, which means no grouping.}

\item{slopeclust}{a vector to specify the grouping for the slopes in Poisson and
ZIP regressions. Default to NULL, which means no grouping.}

\item{group}{a list containing group information.}

\item{maxit}{maximum number iteration. Default to 100.}

\item{tol}{tolerance in the terms of the relative change in the norm of the
common coefficients. Default to 1e-4.}

\item{ncores}{number of cores to be used for parallel programming. Default to 1.}

\item{seed}{a seed for the random initialization of the algorithm}

\item{method}{method for the distributed optimization in the ADMM framework.}

\item{print}{whether to print each iteration. Default to TRUE.}

\item{libpath}{path for the ziphsmm library if not the default set up. Default to NULL.}

\item{...}{Further arguments passed on to the optimization methods}
}
\value{
the maximum likelihood estimates of the zero-inflated hidden Markov model
}
\description{
Distributed learning for a longitudinal continuous-time zero-inflated Poisson
hidden Markov model, where zero-inflation only happens in State 1 with covariates 
in the state-dependent parameters and transition rates.
}
\examples{
\dontrun{
set.seed(12933)
nsubj <- 10
ns <- 2000
ylist <- vector(mode="list",length=nsubj)
xlist <- vector(mode="list",length=nsubj)
timelist <- vector(mode="list",length=nsubj)

priorparm <- 0
tpmparm <- c(-2,0.1,-2,-0.2)
zeroindex <- c(1,0)
zeroparm <- c(0,0.5)
emitparm <- c(2,0.2,3,0.3)
workparm <- NULL

for(n in 1:nsubj){
 
 xlist[[n]] <- matrix(rep(c(0,1),rep(1000,2)),nrow=2000,ncol=1)
 
 timeindex <- rep(1,2000)
 for(i in 2:2000) timeindex[i] <- timeindex[i-1] + sample(1:4,1)
 timelist[[n]] <- timeindex
   
   workparm <- rbind(workparm,c(priorparm,tpmparm,zeroparm,emitparm))
 
 result <- hmmsim3.cont(workparm,2,2000,zeroindex,x=xlist[[n]],timeindex=timeindex)
 ylist[[n]] <- result$series
}


####
M <- 2
priorclust <- c(rep(1,5),rep(2,5))
tpmclust <- c(rep(1,5),rep(2,5))
tpmslopeclust <- c(rep(1,5),rep(2,5))
zeroclust <- NULL
emitclust <- NULL
slopeclust <- rep(1,10)

group <- vector(mode="list",length=2)
group[[1]] <- 1:5; group[[2]] <- 6:10
###
time <- proc.time()
result <- dist_learn3(ylist, xlist, timelist, 2,workparm, 
                     NULL, rho=0.1, priorclust,tpmclust,tpmslopeclust,
                     emitclust,zeroclust,slopeclust,group,ncores=1,
                     maxit=10, tol=1e-4, method="CG",print=TRUE)
proc.time() - time
}
}
\references{
Boyd, S., Parikh, N., Chu, E., Peleato, B. and Eckstein, J., 2011. 
Distributed optimization and statistical learning via the alternating direction method 
of multipliers. Foundations and Trends in Machine Learning, 3(1), pp.1-122.
}
