% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlib.R
\name{decompressobj}
\alias{decompressobj}
\title{Create a new decompressor object}
\usage{
decompressobj(wbits = 0)
}
\arguments{
\item{wbits}{The window size bits parameter. Default is 0.}
}
\value{
A decompressor object with methods for decompression.
}
\description{
Initializes a new decompressor object for zlib-based decompression.
}
\details{
The returned decompressor object has methods for performing chunk-wise
decompression on compressed data using the zlib library.
}
\section{Methods}{

\itemize{
\item \code{decompress(data)}: Compresses a chunk of data.
\item \code{flush()}: Flushes the compression buffer.
}
}

\examples{
compressor <- zlib$compressobj(zlib$Z_DEFAULT_COMPRESSION, zlib$DEFLATED, zlib$MAX_WBITS + 16)
compressed_data <- compressor$compress(charToRaw("some data"))
compressed_data <- c(compressed_data, compressor$flush())
decompressor <- decompressobj(zlib$MAX_WBITS + 16)
decompressed_data <- c(decompressor$decompress(compressed_data), decompressor$flush())

}
