% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fitted.R
\name{get_fitted}
\alias{get_fitted}
\title{Extract estimates of predicted latent proportions.}
\usage{
get_fitted(fitted_model, conf_int = 0.05)
}
\arguments{
\item{fitted_model}{The fitted model returned as an rstan object from the call to zoid}

\item{conf_int}{Parameter controlling confidence intervals calculated, defaults to 0.05
for 95\% intervals}
}
\value{
A list containing the posterior summaries of estimated parameters, with
element \code{mu} (the predicted values in normal space). For predictions
in transformed space, or overdispersion, see \code{\link[=get_pars]{get_pars()}}
}
\description{
Extract point estimates of compositions from fitted model.
}
\examples{
\donttest{
y <- matrix(c(3.77, 6.63, 2.60, 0.9, 1.44, 0.66, 2.10, 3.57, 1.33),
  nrow = 3, byrow = TRUE
)
# fit a model with no covariates
fit <- fit_zoid(data_matrix = y)
p_hat <- get_fitted(fit)
}

}
