% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{create_model}
\alias{create_model}
\title{Create a model}
\usage{
create_model(zoltar_connection, project_url, model_config)
}
\arguments{
\item{zoltar_connection}{A `ZoltarConnection` object as returned by \code{\link{new_connection}}}

\item{project_url}{url of a project in zoltar_connection's projects. this is the project the new model will be created
in}

\item{model_config}{A `list` containing a Zoltar model configuration. An example: example-model-config.json .
Full documentation at \url{https://docs.zoltardata.com/}.}
}
\value{
model_url of the newly-created model
}
\description{
Creates the model in the passed project using the passed list. Fails if a model with the passed name already exists.
}
\examples{
\dontrun{
  new_model_url <- create_model(conn, "https://www.zoltardata.com/project/9/",
                     jsonlite::read_json("example-model-config.json"))
}
}
