## CHANGES IN VERSION 0.5.7 (2017-XX-XX)

### OTHER

+ `zdat` package needed for development and building the vignettes is now
installed from Github using `drat`. Accordingly, various checks are done to 
condition some code to run only if `zdat` is installed.
+ Vignette image dimensions updated.
+ Submitted to CRAN

## CHANGES IN VERSION 0.5.6 (2017-04-13)

### NEW FEATURES

+ New method `cost()` can be used to extract cost data from results. 
Implemented for `Zresults` and `Zvariant`.
+ New utility function `file_path_relative_to()` can be used to
dynamically construct relative paths for spp data.
+ New method `copy_zvariant()` can be used to create a copy of an
existing variant with a new name.

### OTHER

+ Tutorial data removed from `zonator` and placed to a separate data
package `zdat`. This package is required for developing `zonator`.

## CHANGES IN VERSION 0.5.5 (2017-01-16)

### NEW FEATURES

+ `XXX.features_info.txt` is now parsed into `Zresults` objects. This way, 
e.g. species distribution sum information becomes readilly available.

### OTHER

+ Variant names in the tutorial distributed with `zonator` in dir 
`inst/extdata/tutorial` have been truncated to avoid unportable long
paths strings.
+ Bunch of warnings generated by implicit S4 embedding and some tests
have been suppressed.
+ All WARNINGs and NOTEs (except one related to the size of the 
data installation) gone.


## CHANGES IN VERSION 0.5.4 (2016-07-21)

### NEW FEATURES

+ Variant weights can now be easily set using `sppweights()<-`.

## CHANGES IN VERSION 0.5.3 (2016-07-14)

### NEW FEATURES

+ Define the color scheme for `plot_curves()` dynamically between ColorBrewer's 
`Set1` and `Set2`. Where the former has better colors, the latter has more.
+ `create_spp()` accepts new argument `recursive = TRUE` which will look for
rasters in target directory recursively.
+ The `spp_file_dir` for `create_spp()` accepsts multiple directories (in 
vector) instead of just one.
+ New utility `decimalplaces()` can figure out how many decimal places a number
has.
+ `save_zvariant()` now dynamically decides how to format `weight` and `alpha`
column values based on `max(decimalplaces(x))` in the vector.
+ `create_zproject()` now actually checkst if template dat-file exists.

### BUG FIXES

+ Fix default regex pattern for `spp_file_pattern` in `create_spp()`. Previous
version did find .tif and .img file, but also some directories.

## CHANGES IN VERSION 0.5.2 (2016-01-19)

### BUG FIXES

+ Previously all keys had to be present in current group codes when using
`groupnames()<-`. This doesn't make much sense, so now there can be extra groups 
in the value being assigned as long as as all group codes are found in the keys.

## CHANGES IN VERSION 0.5.1 (2016-01-18)

### BUG FIXES

+ Always update groupnames in zvariant@results@grp.curves. Fixes 
[issue #54](https://github.com/cbig/zonator/issues/54).
+ Beacause of the precvious, make `regroup_curves()` always return a 
`ZGroupCurvesDataFrame` object.

## CHANGES IN VERSION 0.5.0 (2016-01-06)

### NEW FEATURES

+ `leaf_tags()` is a new utility function that can get leaf (outermost) tags
and their values in a nested list (used for dat-parsing).
+ `get_dat_param()` can be used to get values of a (valid) Zonation run 
configuration parameter (i.e. the content of a dat-file) from a `Zvariant`
object.
+ `set_dat_param()` can be used to set values of a (valid) Zonation run 
configuration parameter (i.e. the content of a dat-file) for a `Zvariant`
object.
+ `zparameters()` is used to fetch all accepted Zonation run configuration 
parameters (i.e. parameters in the dat file). Can return just the parameter 
names or a list of `[[parameter_name]][[section]]`".
+ `show()` for `Zvariant` now prints run configuration parameters as well.
+ `set_dat_param()` can be used to set run configuration parameters (i.e. dat
file parameters). Only valid parameters are accepted.
+ `get_dat_param()` can be used to get run configuration parameters (i.e. dat
file parameters).
+ `sppdata()<-` allows spp data to be modified. This is mostly needed in 
creating/cpoying variants as editing spp data in place is not probably a good
idea.
+ `save_zvarint()` saves the current state of a `Zvariant` object on the file
system. Saving can overwrite exisiting configuration files or create new.
+ `create_zproject()` now stops if `spp_template_dir` doesn't exist. 
+ Re-implementation of `tools::file_path_sans_ext()` that can handle periods
(".") just before file extension.

### BUG FIXES

+ Assigning groups to a `Zvariant` object when no groups were used initially
failed before (see [issue #45](https://github.com/cbig/zonator/issues/45).), 
fixed now.

### OTHER

+ `read_ini()` renamed to `read_dat()`.
+ `create_zproject()` no longer uses "do_" prefix when generating bat files.
+ Run parameters from dat-files are now parsed as-is. Previously parameter
names were cleaned up (e.g. " " and "-" removed), but this made writing dat
files with correct parameter names really hard. 
+ Much has been changed in the way tutorial data paths are handled internally.
At some point, the whole tutorial data set will be moved to a package of its
own.
+ Removed `plyr` from the dependencies.
+ Make depdendcy to `ggplot2` >= 2.0.0. This way `aes_()` can be used and CHECK
doesn't complain about "undefined global variables" anymore.

## CHANGES IN VERSION 0.4.1 (2015-12-15)

### BUG FIXES

+ Fix [issue #43](https://github.com/cbig/zonator/issues/43).

## CHANGES IN VERSION 0.4.0 (2015-08-17)

### NEW FEATURES

+ `create_zproject()` functionality has been split into two. `create_zproject()`
now handles the creation of a completely new Zonation project (also on the file
system) whereas `load_zproject()` can be used to load existing Zonation 
projects. This change creates a cleaner and more intuitice API. **NOTE** The 
API for `create_zproject()` has changed, so check your code.
+ Vignettes have been much improved. There is now a conceptual intro to 
Zonatio project-variant-results typology as well as how this typology
maps into `zonator` classes.

### BUG FIXES

+ `dir.exists()` replaced with `file.exists()` in spp-creation.

## CHANGES IN VERSION 0.3.14 (2015-07-27)

### NEW FEATURES

+ `plot_curves()` accepts new argument `fix.y` which can be used to fix the 
y-axis to [0, 1]. Useful e.g. plotting runs with condition layers.
+ `modified` slot of a `zresults` object is now parsed from the run info file.
Not ideal, but couldn't figure out a way how to do this reliably on Linux.
+ `print()` and `show()` methods are now implemented for objects of class
`Zvariant`. Makes printing basic data a bit easier.

## CHANGES IN VERSION 0.3.13 (2015-06-14)

### BUG FIXES

+ Result raster pattern matching got confused e.g. by auxiliary files created
by QGIS. Regexp used to match result raster files (img/tif/asc) now better.

## CHANGES IN VERSION 0.3.12 (2015-06-09)

### NEW FEATURES

* New color scheme `RdYlBu` added. This ColorBrewer's 7-level RdYlBu palette.
* New function `create_spp()` can be used to create spp files based on a 
  directory of input raster files.
* `create_zproject()` now works by giving it a directory containing input 
  rasters based on which the spp files are created. 


## CHANGES IN VERSION 0.3.11 (2015-06-08)

* Update package vignettes.

### NEW FEATURES

* New tests and checks for `read_ini()`.
* New color scheme `BrBG ` added. This a slight variation from 
ColorBrewer's 7-level BrBG scheme with the lowest value replaced with grey.

## CHANGES IN VERSION 0.3.10 (2014-08-12)

### BUG FIXES

* Fix imports in roxygen2 docs

* Generic group names assigned at initiation. If Zvariant object has groups 
  enabled, assign generic group names "group1", "group2" to groups 
  automatically.
  
* Generic group ID larger than 10 would not get mapped right because of a sloppy
  gsub-replacement. Regex fixed and `groupnames()<-` should work correctly when
  one has more than 10 groups.
  
* `get_variant()` for `Zproject` objects now checks the input index properly
(~~[issue34](https://github.com/cbig/zonator/issues/34)~~)

* Trying to get rank rasters from a set of variants with no rank rasters 
available caused and error, now produces warnings and returns a NA. 

### NEW FEATURES

* New function `ds_alpha()` that can be used to calculate alpha value for 
  distribution smoothing.
  
### API CHANGES

* Rename `weights` to `sppweights` so that it doesn't overwrite base generic.

## CHANGES IN VERSION 0.3.9 (2014-03-31)

### BUG FIXES

* Assigning group names now works correctly with generic default values and
  whenever groups (ids) are changed. (~~[issue29](https://github.com/cbig/zonator/issues/29)~~)
  
* Generic group naming now works, i.e. if group ids are changed group names
  get a generic value "group1", "group2" etc. (~~[issue22](https://github.com/cbig/zonator/issues/22)~~)

### NEW FEATURES

* Assigning group ids with `groups()<-` now recalculates group specific 
  stats (min, mean, max, weighted mean) for defined groups. In other words,
  it is now possible to define groups other than those defined in Zonation
  groups file and have the group curves data calculated for the new groups.

* `cross_jaccard()` now returns a dataframe with correct RasterLayer names
  colnames and rownames.
  
* `cross_jaccard()` now accpets a numeric vector of threshold values for
  comparison.
  
* `jaccard()` now has additional parameters for controlling the thresholds for
  rasters `x` and `y` being compared. Arguments `xmin`, `xmax`, `ymin`, and 
  `ymax` can be used to control which ranges of the raster values are compared.

* New methods for class `Zproject`:
  - Method `rank_rasters()` accepts a new argument `variants` which can be
  either a character of numeric vector of variant names / IDs defining which
  rank rasters are included in the RasterStack that is returned. Default is 
  to return all.
  
* New methods for class `Zvariant`:
  - Methods `weights()` returns a numeric vector of weights assigned to a 
  variant.

## CHANGES IN VERSION 0.3.8 (2014-03-17)

### BUG FIXES

### NEW FEATURES

* Creating new Zproject object based on an existing Zonation project involves
  reading in a lot of files and it can be useful to know the sequence of reading
  in case something goes wront. `create_zproject()` now accepts a new argument
  `debug=TRUE` which enables logging of file reading sequence. (~~[issue28](https://github.com/cbig/zonator/issues/28)~~)

* New methods for class `Zvariant`:
  - Generic replacement method `groups()<-`
  - Method `nfeatures()` returns the number of features in a variant


## CHANGES IN VERSION 0.3.7 (2014-02-05)

### BUG FIXES

* Fix bugs in tests
* `check_zonation()` fixed on Windows (~~[issue26](https://github.com/cbig/zonator/issues/26)~~)

### NEW FEATURES

* New methods for class `ZCurvesDataFrame`:
  - `featurenames()`

## CHANGES IN VERSION 0.3.6 (2014-01-24)

### BUG FIXES

* Fix initial feature naming (~~[issue24](https://github.com/cbig/zonator/issues/24)~~)
* `check_path()` works on Windows (~~[issue23](https://github.com/cbig/zonator/issues/23)~~)
* Fix several tests on Windows 

## CHANGES IN VERSION 0.3.5 (2014-01-20)

### NEW FEATURES

* Results vignette has bee updated.

* Post-processign (PPA) LSM results are now handled by `Zresults`. Results,
if present, are read in from the output folder. More specifically:
  - Class `Zresults` now defines a new slot `ppa.lsm` tha holds the content
  of PPA LSM results

* `zlegend()` can be used to fetch Zonation rank raster map legend schemes. So
  far only one scheme ("spectral") is implemented.

* New methods for class `Zproject`:
  - `rank_rasters()`: returns a `RasterStack` of all priority rank rasters
  of all variants within a project

* New methods for class `Zvariant`:
  - Implented `curves()`

* New methods for class `Zvariant` and `Zresults`:
  - `rank_raster()`: returns `RasterLayer` of priority rank raster of a given
  variant or its results

## CHANGES IN VERSION 0.3.4 (2014-01-14)

### NEW FEATURES

* New methods for class `Zproject`:
  - `variants()`: returns a list containing all the variants within a project

* New methods for class `Zvariant` and `Zresults`:
  - `outdir()`: returns the path to location of output dirctory
  
## CHANGES IN VERSION 0.3.3 (2013-12-20)

Maintance update, R CMD check and TravisCI test passes after few minor fixes.

## CHANGES IN VERSION 0.3.2 (2013-12-19)

* Class `Zcurves` has been refactored to 2 classes: `ZCurvesDataFrame` and 
`ZGroupCurvesDataFrame`. Change was introduced mostly to handle performance
curves plotting more sensibly.

### NEW FEATURES

* Generic `groupnames()` now returns a character vector instead of a named 
character vector (with names being the original group numbers)

* `plot()` now works for `ZCurvesDataFrame` and `ZGroupCurvesDataFrame` objecs.

* New methods for class `Zresults`:
  - `groupnames()`
  
## NEW DEPENDENCIES

* RColorBrewer 

## CHANGES IN VERSION 0.3.1 (2013-12-11)

### NEW FEATURES

* bat-files are read recursively when creating a project (~~[issue20](https://github.com/cbig/zonator/issues/20)~~)
* `check_paths()` now deals with relative path components 
* `has_results()` now returns a list of logicals instead of a single logical

* New methods for class `Zresults`:
  - `has_results()`: returns a list of TRUE/FALSE depending on whether the 
  particular results items (curves, grp.curves, rank, wrscr, prop) are available
  or not

## CHANGES IN VERSION 0.3.0 (2013-12-05)

* Much of the internal functionality has been re-written
* Documentation is improving, but still needs a lot of work

### NEW FEATURES

* New classes `Zresults` and `Zcurves`. See docs for methods and structure.

* New methods for class `Zvariant`:
  - `groupnames()<-`: assign human readable group names
  - `groupnames()`: get assigned unique groupnames and codes
  - `has_results()`: returns TRUE/FALSE depending on whether the variant has 
  results or not
  - `results()`: returns a `Zresults` object specific to a `Zvariant` object

## CHANGES IN VERSION 0.2.2 (2013-11-28)

* Feature can be named for each variant and feature and group identities can
be joined and queried. 

### NEW FEATURES

* New methods for class `Zvariant`:
  - `featurenames()<-`: assign human readable feature names
  - `featurenames()`: get assigned unique featurenames
  - `sppdata()`: return the whole spp data frame of a variant

## CHANGES IN VERSION 0.2.1 (2013-11-27)

* Add groups functionality to `Zvariant`. Groups are read in from the actual
Zonation input file and can be used (eventually) in many operations.

### NEW FEATURES

* New methods for class `Zvariant`:
  - `groups()`: returns a numeric vector containing group codes for features
  - `groupnames()<-`: assign human readable group names to groups
  - `groupnames()`: get assigned unique groupnames with associated group codes 

* New utlity functions:
  - `read_groups()`: read in Zonation groups file

## CHANGES IN VERSION 0.2.0 (2013-11-22)

* Refactor all function names to follow underscore "_" pattern. Assume all
old calls broken.

## CHANGES IN VERSION 0.1.3 (2013-11-15)

* Updated the tutorial data shipping with zonator to correspond with the updated
Zonation tutorial (basic)
* Started using knit/Rmd to create vignettes
* Started NEWS document

### NEW FEATURES

* New methods for class `Zpoject`:
  - `names()`: returns a character vector of the names of variants in a project

* New methods for class `Zvariant`:
  - `has_results()`: boolean indicating whether the variant already has associated
    results

* New utlity functions:
  - `read.spp()`: read in spp files
