





















#[cfg(maybe_uninit)]
#[macro_export]
#[doc(hidden)]
macro_rules! _memoffset__let_base_ptr {
    ($name:ident, $type:ty) => {





        let uninit = $crate::__priv::mem::MaybeUninit::<$type>::uninit();
        let $name: *const $type = uninit.as_ptr();
    };
}
#[cfg(not(maybe_uninit))]
#[macro_export]
#[doc(hidden)]
macro_rules! _memoffset__let_base_ptr {
    ($name:ident, $type:ty) => {


        let $name = $crate::__priv::mem::align_of::<$type>() as *const $type;
    };
}


#[cfg(any(feature = "unstable_const", stable_const))]
#[macro_export]
#[doc(hidden)]
macro_rules! _memoffset_offset_from_unsafe {
    ($field:expr, $base:expr) => {{
        let field = $field; // evaluate $field outside the `unsafe` block
        let base = $base; // evaluate $base outside the `unsafe` block


        unsafe { (field as *const u8).offset_from(base as *const u8) as usize }
    }};
}
#[cfg(not(any(feature = "unstable_const", stable_const)))]
#[macro_export]
#[doc(hidden)]
macro_rules! _memoffset_offset_from_unsafe {
    ($field:expr, $base:expr) => {

        ($field as usize) - ($base as usize)
    };
}
#[cfg(not(feature = "unstable_offset_of"))]
#[macro_export(local_inner_macros)]
#[doc(hidden)]
macro_rules! _memoffset__offset_of_impl {
    ($parent:path, $field:tt) => {{

        _memoffset__let_base_ptr!(base_ptr, $parent);

        let field_ptr = raw_field!(base_ptr, $parent, $field);

        _memoffset_offset_from_unsafe!(field_ptr, base_ptr)
    }};
}
#[cfg(feature = "unstable_offset_of")]
#[macro_export]
#[doc(hidden)]
#[allow_internal_unstable(offset_of)]
macro_rules! _memoffset__offset_of_impl {
    ($parent:path, $field:tt) => {{
        $crate::__priv::mem::offset_of!($parent, $field)
    }};
}





























#[macro_export(local_inner_macros)]
macro_rules! offset_of {
    ($parent:path, $field:tt) => {
        _memoffset__offset_of_impl!($parent, $field)
    };
}











#[cfg(tuple_ty)]
#[macro_export(local_inner_macros)]
macro_rules! offset_of_tuple {
    ($parent:ty, $field:tt) => {{

        _memoffset__let_base_ptr!(base_ptr, $parent);

        let field_ptr = raw_field_tuple!(base_ptr, $parent, $field);

        _memoffset_offset_from_unsafe!(field_ptr, base_ptr)
    }};
}

#[cfg(not(feature = "unstable_offset_of"))]
#[macro_export(local_inner_macros)]
#[doc(hidden)]
macro_rules! _memoffset__offset_of_union_impl {
    ($parent:path, $field:tt) => {{

        _memoffset__let_base_ptr!(base_ptr, $parent);

        let field_ptr = raw_field_union!(base_ptr, $parent, $field);

        _memoffset_offset_from_unsafe!(field_ptr, base_ptr)
    }};
}

#[cfg(feature = "unstable_offset_of")]
#[macro_export(local_inner_macros)]
#[doc(hidden)]
#[allow_internal_unstable(offset_of)]
macro_rules! _memoffset__offset_of_union_impl {
    ($parent:path, $field:tt) => {{
        $crate::__priv::mem::offset_of!($parent, $field)
    }};
}






















#[macro_export(local_inner_macros)]
macro_rules! offset_of_union {
    ($parent:path, $field:tt) => {{
        _memoffset__offset_of_union_impl!($parent, $field)
    }};
}

#[cfg(test)]
mod tests {
    #[test]
    fn offset_simple() {
        #[repr(C)]
        struct Foo {
            a: u32,
            b: [u8; 2],
            c: i64,
        }

        assert_eq!(offset_of!(Foo, a), 0);
        assert_eq!(offset_of!(Foo, b), 4);
        assert_eq!(offset_of!(Foo, c), 8);
    }

    #[test]
    #[cfg_attr(miri, ignore)] // this creates unaligned references
    fn offset_simple_packed() {
        #[repr(C, packed)]
        struct Foo {
            a: u32,
            b: [u8; 2],
            c: i64,
        }

        assert_eq!(offset_of!(Foo, a), 0);
        assert_eq!(offset_of!(Foo, b), 4);
        assert_eq!(offset_of!(Foo, c), 6);
    }

    #[test]
    fn tuple_struct() {
        #[repr(C)]
        struct Tup(i32, i32);

        assert_eq!(offset_of!(Tup, 0), 0);
        assert_eq!(offset_of!(Tup, 1), 4);
    }

    #[test]
    fn offset_union() {

        #[repr(C)]
        union Foo {
            a: u32,
            b: [u8; 2],
            c: i64,
        }

        assert_eq!(offset_of_union!(Foo, a), 0);
        assert_eq!(offset_of_union!(Foo, b), 0);
        assert_eq!(offset_of_union!(Foo, c), 0);
    }

    #[test]
    fn path() {
        mod sub {
            #[repr(C)]
            pub struct Foo {
                pub x: u32,
            }
        }

        assert_eq!(offset_of!(sub::Foo, x), 0);
    }

    #[test]
    fn inside_generic_method() {
        struct Pair<T, U>(T, U);

        fn foo<T, U>(_: Pair<T, U>) -> usize {
            offset_of!(Pair<T, U>, 1)
        }

        assert_eq!(foo(Pair(0, 0)), 4);
    }

    #[cfg(tuple_ty)]
    #[test]
    fn test_tuple_offset() {
        let f = (0i32, 0.0f32, 0u8);
        let f_ptr = &f as *const _;
        let f1_ptr = &f.1 as *const _;

        assert_eq!(
            f1_ptr as usize - f_ptr as usize,
            offset_of_tuple!((i32, f32, u8), 1)
        );
    }

    #[test]
    fn test_raw_field() {
        #[repr(C)]
        struct Foo {
            a: u32,
            b: [u8; 2],
            c: i64,
        }

        let f: Foo = Foo {
            a: 0,
            b: [0, 0],
            c: 0,
        };
        let f_ptr = &f as *const _;
        assert_eq!(f_ptr as usize + 0, raw_field!(f_ptr, Foo, a) as usize);
        assert_eq!(f_ptr as usize + 4, raw_field!(f_ptr, Foo, b) as usize);
        assert_eq!(f_ptr as usize + 8, raw_field!(f_ptr, Foo, c) as usize);
    }

    #[cfg(tuple_ty)]
    #[test]
    fn test_raw_field_tuple() {
        let t = (0u32, 0u8, false);
        let t_ptr = &t as *const _;
        let t_addr = t_ptr as usize;

        assert_eq!(
            &t.0 as *const _ as usize - t_addr,
            raw_field_tuple!(t_ptr, (u32, u8, bool), 0) as usize - t_addr
        );
        assert_eq!(
            &t.1 as *const _ as usize - t_addr,
            raw_field_tuple!(t_ptr, (u32, u8, bool), 1) as usize - t_addr
        );
        assert_eq!(
            &t.2 as *const _ as usize - t_addr,
            raw_field_tuple!(t_ptr, (u32, u8, bool), 2) as usize - t_addr
        );
    }

    #[test]
    fn test_raw_field_union() {
        #[repr(C)]
        union Foo {
            a: u32,
            b: [u8; 2],
            c: i64,
        }

        let f = Foo { a: 0 };
        let f_ptr = &f as *const _;
        assert_eq!(f_ptr as usize + 0, raw_field_union!(f_ptr, Foo, a) as usize);
        assert_eq!(f_ptr as usize + 0, raw_field_union!(f_ptr, Foo, b) as usize);
        assert_eq!(f_ptr as usize + 0, raw_field_union!(f_ptr, Foo, c) as usize);
    }

    #[cfg(any(
        feature = "unstable_const",
        feature = "unstable_offset_of",
        stable_const
    ))]
    #[test]
    fn const_offset() {
        #[repr(C)]
        struct Foo {
            a: u32,
            b: [u8; 2],
            c: i64,
        }

        assert_eq!([0; offset_of!(Foo, b)].len(), 4);
    }

    #[cfg(feature = "unstable_const")]
    #[test]
    fn const_offset_interior_mutable() {
        #[repr(C)]
        struct Foo {
            a: u32,
            b: core::cell::Cell<u32>,
        }

        assert_eq!([0; offset_of!(Foo, b)].len(), 4);
    }

    #[cfg(any(
        feature = "unstable_const",
        feature = "unstable_offset_of",
        stable_const
    ))]
    #[test]
    fn const_fn_offset() {
        const fn test_fn() -> usize {
            #[repr(C)]
            struct Foo {
                a: u32,
                b: [u8; 2],
                c: i64,
            }

            offset_of!(Foo, b)
        }

        assert_eq!([0; test_fn()].len(), 4);
    }
}
