## ---- include=FALSE------------------------------------------------------
library(knitr)
opts_chunk$set(out.extra='style="display:block; margin: auto"', fig.align="center", fig.width=6, fig.height=6)

## ---- eval = FALSE-------------------------------------------------------
#  library(devtools)
#  install_github('zoonproject/zoon')

## ------------------------------------------------------------------------
library(zoon)

## ---- warning = FALSE----------------------------------------------------
work1 <- workflow(occurrence = UKAnophelesPlumbeus,
                  covariate  = UKAir,
                  process    = OneHundredBackground,
                  model      = RandomForest,
                  output     = PrintMap)

class(work1)
str(work1, 1)

## ---- eval = FALSE-------------------------------------------------------
#  GetModuleList()

## ---- eval = FALSE-------------------------------------------------------
#  ModuleHelp(LogisticRegression)

## ---- warning = FALSE----------------------------------------------------
work2 <- workflow(occurrence = UKAnophelesPlumbeus,
                  covariate  = UKAir,
                  process    = BackgroundAndCrossvalid(k = 2),
                  model      = LogisticRegression,
                  output     = PerformanceMeasures)

## ---- warnings = FALSE---------------------------------------------------
work3 <- workflow(occurrence = UKAnophelesPlumbeus,
                  covariate  = UKAir,
                  process    = Chain(OneHundredBackground, Crossvalidate),
                  model      = LogisticRegression,
                  output     = PerformanceMeasures)

## ---- warning = FALSE----------------------------------------------------
work4 <- workflow(occurrence = UKAnophelesPlumbeus,
                  covariate  = UKAir,
                  process    = OneHundredBackground,
                  model      = list(LogisticRegression, RandomForest),
                  output     = PrintMap)

str(work4, 1)

## ---- warning = FALSE, fig.height=12-------------------------------------
work5 <- workflow(occurrence = Chain(SpOcc(species = 'Eresus kollari', 
                                       extent = c(-10, 10, 45, 65)),
                                     SpOcc(species = 'Eresus sandaliatus', 
                                       extent = c(-10, 10, 45, 65))),
                  covariate = UKAir,
                  process = BackgroundAndCrossvalid(k = 2),
                  model = list(LogisticRegression,
                               RandomForest),
                  output = Chain(PrintMap(plot = FALSE),
                                 PerformanceMeasures)
         )

# Take a look at the structure of hte workflow object
str(work5, 1)

# Create some custom plots using the raster returned from 
# the output module ($report)
par(mfrow = c(2,1), mar = c(3,4,6,4))
plot(work5$report[[1]][[1]], 
     main = paste('Logistic Regression: AUC = ', 
             round(work5$report[[1]][[2]]$auc, 2)),
     xlim = c(-10, 10))
plot(work5$report[[2]][[1]],
  main = paste('Random forest: AUC = ', 
             round(work5$report[[2]][[2]]$auc, 2)))

