\name{aero_calc}
\alias{aero_calc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
aero_calc
}
\description{
This package uses the aerodynamic mass transfer approach on variables given in the input file to estimate open water evaporation. The output includes calculated evaporation parameters as well as the input values.
}
\usage{
 aero_calc(df, sensor_height, timestep, out_file_format,out_file_name, verbose)
}

\arguments{
  \item{df}{
      Dataframe containing input data. Must include all data components ('T_skin', 'WS', 'P', 'T_air', 'RH', 'date').
      Ensure date is formatted as a date object before reading into function.
}
  \item{sensor_height}{
      Sensor height (m)
  }
  \item{timestep}{
      Measurement frequency (s). For example, hourly data would be timestep = 3600
  }
  \item{out_file_format}{
    Format for output file
  }
  \item{out_file_name}{
    Name for saved file
  }
  \item{verbose}{
    Logical indicator to hide output messages (FALSE will hide messages)
  }
}
\details{
Returns a list with calculated values for evaporation (mm/timestep), bulk transfer coefficient, vapor pressure deficit (kPa), and most stability value
}
\value{
  \item{SH}{
    Sensor height (m)}

  \item{dt}{
    Timestep}

  \item{E}{
    Evaporation (mm/timestep)}

  \item{Ce}{
    bulk transfer coefficent (unitless)}

  \item{VPD}{
    Vapor pressure deficit (kPA)}

  \item{stability}{
    Monin-Obhukov Similarity Theory stability parameter (z/L)}

}
\references{
AeroEvap (Python version): \href{https://github.com/WSWUP/AeroEvap/tree/master}{https://github.com/WSWUP/AeroEvap/tree/master}
}
\author{
Ally Fitts (afitts@usbr.gov)\\
Elise Madonna\\
Kathleen Holman\\
John Volk \\
Chris Pearson\\

}
\note{
This package was developed based on AeroEvap, a Python implementation of the aerodynamic mass-transfer approach for open-water evaporation. See \href{https://github.com/WSWUP/AeroEvap/tree/master}{AeroEvap on GitHub}.
}


\examples{
old_par <- par(no.readonly = TRUE)

df <- data.frame(
  date = seq(as.POSIXct("2020-01-01"), by = 3600, length.out = 5),
  T_skin = c(20, 21, 22, 21, 20),
  WS = c(3, 3.5, 4, 3.8, 3.2),
  P = rep(101.3, 5),
  T_air = c(18, 18.5, 19, 18.8, 18.2),
  RH = c(50, 52, 51, 49, 50)
)

# Run aero_calc with sample inputs
result <- aero_calc(df,
                    sensor_height = 2,
                    timestep = 3600,
                    out_file_format = "none",
                    out_file_name = NULL,
                    verbose = TRUE)

# View results
print(result)

# Reset graphical parameters
par(old_par)
}

