% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{check}
\alias{check}
\alias{is_original}
\alias{is_original-method}
\alias{is_original,MCMC-method}
\alias{is_original,PhasesMCMC-method}
\alias{is_original,CumulativeEvents-method}
\alias{is_original,ActivityEvents-method}
\alias{is_original,OccurrenceEvents-method}
\title{Check for an Original MCMC File}
\usage{
is_original(object, ...)

\S4method{is_original}{MCMC}(object, file, download = FALSE)

\S4method{is_original}{PhasesMCMC}(object, file, download = FALSE)

\S4method{is_original}{CumulativeEvents}(object, file, download = FALSE)

\S4method{is_original}{ActivityEvents}(object, file, download = FALSE)

\S4method{is_original}{OccurrenceEvents}(object, file, download = FALSE)
}
\arguments{
\item{object}{An object (typically an \code{\linkS4class{MCMC}} object).}

\item{...}{Currently not used.}

\item{file}{Either a path to a CSV file or a connection.}

\item{download}{A \code{\link{logical}} scalar: should the remote file be downloaded
and hashed locally?}
}
\value{
A \code{\link{logical}}: \code{TRUE} if the files match, \code{FALSE} otherwise.
}
\description{
Checks whether or not a file is identical to the one used to create
an object.
}
\examples{
\dontrun{
## Import OxCal Output
path_output <- system.file("oxcal/ksarakil/MCMC_Sample.csv", package = "ArchaeoData")
url_output <- paste0("https://raw.githubusercontent.com/ArchaeoStat/ArchaeoData/master/",
                     "inst/oxcal/ksarakil/MCMC_Sample.csv")

oxcal <- read_oxcal(path_output)

## Check md5 sum
is_original(oxcal, path_output) # Same as local file? TRUE
is_original(oxcal, url_output, download = FALSE) # Same as remote file? FALSE
is_original(oxcal, url_output, download = TRUE) # Same as remote file? TRUE
}
}
\seealso{
\code{\link[digest:digest]{digest::digest()}}

Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{as_phases}()},
\code{\link{read_bcal}()},
\code{\link{read_chronomodel}},
\code{\link{read_oxcal}()}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{read methods}
