% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/read.R
\docType{methods}
\name{read_oxcal}
\alias{read_oxcal}
\alias{read_oxcal-method}
\alias{read_oxcal,character-method}
\title{Read OxCal Output}
\usage{
read_oxcal(file, ...)

\S4method{read_oxcal}{character}(file, calendar = CE())
}
\arguments{
\item{file}{A \code{\link{character}} string giving the name of the CSV file which the
data are to be read from.}

\item{...}{Currently not used.}

\item{calendar}{A \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the calendar
(see \code{\link[aion:calendar]{aion::calendar()}}). It should be \code{\link[aion:gregorian]{aion::CE()}} unless you change the
default settings in 'OxCal'.}
}
\value{
An \code{\linkS4class{EventsMCMC}} object.
}
\description{
Reads MCMC output.
}
\examples{
if (requireNamespace("ArchaeoData", quietly = TRUE)) {
  ## Construct the path to the data
  path <- file.path("oxcal", "ksarakil")
  path_output <- system.file(path, "MCMC_Sample.csv", package = "ArchaeoData")

  ## Import OxCal Output
  (oxcal <- read_oxcal(path_output))
}
}
\references{
Bronk Ramsey, C. (2009). Bayesian Analysis of Radiocarbon Dates.
\emph{Radiocarbon}, 51(1), 337-360. \doi{10.1017/S0033822200033865}.
}
\seealso{
\code{\link[utils:read.table]{utils::read.table()}}

Other read methods: 
\code{\link{as_coda}()},
\code{\link{as_events}()},
\code{\link{as_phases}()},
\code{\link{check}},
\code{\link{read_bcal}()},
\code{\link{read_chronomodel}}
}
\author{
T. S. Dye, N. Frerebeau
}
\concept{read methods}
