% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_abcl_sum}
\alias{compute_mh_p_abcl_sum}
\title{Compute "Adult Behavior Checklist [Parent]: Sum"}
\usage{
compute_mh_p_abcl_sum(
  data,
  name = "mh_p_abcl_sum",
  max_na = 8,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_abcl_sum}
Adult Behavior Checklist [Parent]: Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_abcl__rule_001}
\item \code{mh_p_abcl__attn__adhd_002}
\item \code{mh_p_abcl__tho_001}
\item \code{mh_p_abcl__othpr__adhd_001}
\item \code{mh_p_abcl__anxdep__dep_001}
\item \code{mh_p_abcl__aggr__antsoc_003}
\item \code{mh_p_abcl__tho__dep_001}
\item \code{mh_p_abcl__othpr__antsoc_001}
\item \code{mh_p_abcl__tho_002}
\item \code{mh_p_abcl__aggr_001}
\item \code{mh_p_abcl__aggr__antsoc_006}
\item \code{mh_p_abcl__tho_003}
\item \code{mh_p_abcl__tho_004}
\item \code{mh_p_abcl__tho_006}
\item \code{mh_p_abcl__rule_002}
\item \code{mh_p_abcl__tho__dep_002}
\item \code{mh_p_abcl__rule__antsoc_007}
\item \code{mh_p_abcl__aggr__antsoc_008}
\item \code{mh_p_abcl__anxdep__dep_004}
\item \code{mh_p_abcl__aggr__adhd_001}
\item \code{mh_p_abcl__attn__adhd_001}
\item \code{mh_p_abcl__attn__adhd_003}
\item \code{mh_p_abcl__attn__adhd_004}
\item \code{mh_p_abcl__attn__adhd_005}
\item \code{mh_p_abcl__attn__adhd_006}
\item \code{mh_p_abcl__attn__adhd_007}
\item \code{mh_p_abcl__othpr__adhd_002}
\item \code{mh_p_abcl__othpr__adhd_003}
\item \code{mh_p_abcl__othpr__adhd_004}
\item \code{mh_p_abcl__rule__adhd_001}
\item \code{mh_p_abcl__aggr__antsoc_001}
\item \code{mh_p_abcl__aggr__antsoc_002}
\item \code{mh_p_abcl__aggr__antsoc_004}
\item \code{mh_p_abcl__aggr__antsoc_005}
\item \code{mh_p_abcl__aggr__antsoc_007}
\item \code{mh_p_abcl__attn__antsoc_001}
\item \code{mh_p_abcl__othpr__antsoc_002}
\item \code{mh_p_abcl__rule__antsoc_001}
\item \code{mh_p_abcl__rule__antsoc_002}
\item \code{mh_p_abcl__rule__antsoc_003}
\item \code{mh_p_abcl__rule__antsoc_004}
\item \code{mh_p_abcl__rule__antsoc_005}
\item \code{mh_p_abcl__rule__antsoc_006}
\item \code{mh_p_abcl__rule__antsoc_008}
\item \code{mh_p_abcl__rule__antsoc_009}
\item \code{mh_p_abcl__anxdep__anx_001}
\item \code{mh_p_abcl__anxdep__anx_002}
\item \code{mh_p_abcl__anxdep__anx_003}
\item \code{mh_p_abcl__othpr__anx_001}
\item \code{mh_p_abcl__othpr__anx_002}
\item \code{mh_p_abcl__othpr__anx_003}
\item \code{mh_p_abcl__anxdep__avoid_001}
\item \code{mh_p_abcl__anxdep__avoid_002}
\item \code{mh_p_abcl__othpr__avoid_001}
\item \code{mh_p_abcl__wthdr__avoid_001}
\item \code{mh_p_abcl__wthdr__avoid_002}
\item \code{mh_p_abcl__wthdr__avoid_003}
\item \code{mh_p_abcl__wthdr__avoid_004}
\item \code{mh_p_abcl__anxdep__dep_002}
\item \code{mh_p_abcl__anxdep__dep_003}
\item \code{mh_p_abcl__anxdep__dep_005}
\item \code{mh_p_abcl__attn__dep_001}
\item \code{mh_p_abcl__attn__dep_002}
\item \code{mh_p_abcl__attn__dep_003}
\item \code{mh_p_abcl__othpr__dep_001}
\item \code{mh_p_abcl__othpr__dep_002}
\item \code{mh_p_abcl__othpr__dep_003}
\item \code{mh_p_abcl__som__dep_001}
\item \code{mh_p_abcl__wthdr__dep_001}
\item \code{mh_p_abcl__som__somat_001}
\item \code{mh_p_abcl__som__somat_002}
\item \code{mh_p_abcl__som__somat_003}
\item \code{mh_p_abcl__som__somat_004}
\item \code{mh_p_abcl__som__somat_005}
\item \code{mh_p_abcl__som__somat_006}
\item \code{mh_p_abcl__som__somat_007}
\item \code{mh_p_abcl__aggr_002}
\item \code{mh_p_abcl__aggr_003}
\item \code{mh_p_abcl__aggr_004}
\item \code{mh_p_abcl__aggr_005}
\item \code{mh_p_abcl__aggr_006}
\item \code{mh_p_abcl__aggr_007}
\item \code{mh_p_abcl__anxdep_001}
\item \code{mh_p_abcl__anxdep_002}
\item \code{mh_p_abcl__anxdep_003}
\item \code{mh_p_abcl__anxdep_004}
\item \code{mh_p_abcl__attn_001}
\item \code{mh_p_abcl__attn_002}
\item \code{mh_p_abcl__attn_003}
\item \code{mh_p_abcl__attn_004}
\item \code{mh_p_abcl__attn_005}
\item \code{mh_p_abcl__attn_006}
\item \code{mh_p_abcl__rule_003}
\item \code{mh_p_abcl__intru_001}
\item \code{mh_p_abcl__intru_002}
\item \code{mh_p_abcl__intru_003}
\item \code{mh_p_abcl__intru_004}
\item \code{mh_p_abcl__intru_005}
\item \code{mh_p_abcl__intru_006}
\item \code{mh_p_abcl__wthdr_001}
\item \code{mh_p_abcl__wthdr_002}
\item \code{mh_p_abcl__wthdr_003}
\item \code{mh_p_abcl__wthdr_004}
\item \code{mh_p_abcl__som_001}
\item \code{mh_p_abcl__othpr_001}
\item \code{mh_p_abcl__othpr_002}
\item \code{mh_p_abcl__othpr_003}
\item \code{mh_p_abcl__othpr_004}
\item \code{mh_p_abcl__othpr_005}
\item \code{mh_p_abcl__othpr_006}
\item \code{mh_p_abcl__othpr_007}
\item \code{mh_p_abcl__othpr_008}
\item \code{mh_p_abcl__othpr_009}
\item \code{mh_p_abcl__othpr_010}
\item \code{mh_p_abcl__othpr_011}
\item \code{mh_p_abcl__othpr_012}
\item \code{mh_p_abcl__tho_005}
\item \code{mh_p_abcl__tho_007}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 8 of 118 items missing
}
}
\examples{
\dontrun{
compute_mh_p_abcl_sum(data) |>
  select(
    any_of(c("mh_p_abcl_sum", vars_mh_p_abcl))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_abcl_nm]{compute_mh_p_abcl_nm()}}
}
