% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABPS.R
\name{ABPS}
\alias{ABPS}
\title{A function for calculating the Abnormal Blood Profile Score}
\usage{
ABPS(haemdata = NULL, HCT = NULL, HGB = NULL, MCH = NULL, MCHC = NULL,
  MCV = NULL, RBC = NULL, RETP = NULL)
}
\arguments{
\item{haemdata}{a vector or data frame containing (at least) the 7
haematological variables, either with the same names as the
parameters below, or (not recommended) without names but in the
same order as the parameters.}

\item{HCT}{the haematocrit level (in \%)}

\item{HGB}{the haemoglobin level (in [g/l])}

\item{MCH}{the mean corpuscular haemoglobin (in [pg])}

\item{MCHC}{the mean corpuscular haemoglobin concentration (in
[g/dL])}

\item{MCV}{Mean corpuscular volume (in [fL])}

\item{RBC}{the red blood cell count (in [10^6/mu l])}

\item{RETP}{the reticulocytes percent (in \%)}
}
\value{
a vector containing the ABPS score(s). Scores between 0 and
    1 indicate a possible suspicion of doping, while scores above 1
    indicate that the likelihood of doping is higher than the
    likelihood of no-doping.
}
\description{
The \code{ABPS} function computes the Abnormal Blood Profile Score
from seven haematological markers. Higher values of this composite
score are associated with a higher likelihood of blood doping;
}
\details{
The ABPS uses the seven haematological variables (HCT, HGB, MCH,
MCHC, MCV, RBC, RET\%) in order to obtain a combined score. This
score is more sensitive to doping than the individual markers, and
allows the detection of several types of blood doping using a
single score.

The combined score is based on two classification techniques, a
naive Bayesian classifier and an SVM (Support Vector Machine). The
two models were trained using a database of 591 blood profiles
(including 402 control samples from clean athletes and 189 samples
of athletes who abused of an illegal substance); the two scores
were then combined using ensemble averaging to obtain the final
ABPS score.

The ABPS is part of the Athlete Biological Passport program managed
by the World Anti-Doping Agency. While it is not a primary marker
of doping, it has been used as corroborative evidence (see e.g.
\url{https://jurisprudence.tas-cas.org/Shared\%20Documents/2773.pdf})
}
\section{Note}{


The calculation of the ABPS depends on two sets of parameters, for
the two machine learning techniques (naive Bayesian classifier and
Support Vector Machine), which are provided in the package.

Each parameter must be in a prespecified range; parameters outside
this range are constrained to the min (respectively max) values.

Note that several versions of the ABPS were developed (including
several different combinations of parameters). The version provided
in this package provides the same results as the WADA version
included in their ADAMS database. However, some values calculated
with other versions of the software have also been distributed (see
the help page for the \code{blooddoping} dataset for an example).
}

\section{References}{

Sottas, P.E., N. Robinson, S. Giraud, et al., Statistical classification of abnormal blood profiles in athletes. Int J Biostat, 2006. 2(1): p. 1557-4679.

\url{https://jurisprudence.tas-cas.org/Shared\%20Documents/2773.pdf}
}

\examples{
ABPS(HCT=43.2, HGB=14.6, MCH=31.1, MCHC=33.8, MCV=92.1, RBC=4.69, RETP=0.48)
ABPS(data.frame(HCT=43.2, HGB=14.6, MCH=31.1, MCHC=33.8, MCV=92.1, RBC=4.69, RETP=0.48))
ABPS(c(43.2, 14.6, 31.1, 33.8, 92.1, 4.69, 0.48))
data(blooddoping); ABPS(blooddoping)
data(bloodcontrol); ABPS(bloodcontrol)

}
