% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_diff.R
\name{auto_diff}
\alias{auto_diff}
\title{Automatic differentiation}
\usage{
auto_diff(f, wrt = NULL, at)
}
\arguments{
\item{f}{A function of which the derivative is sought.}

\item{wrt}{A character vector; the name of the variables to differentiate with respect to.}

\item{at}{A named list of variables; the point at which the derivative is evaluated.}
}
\value{
A dual number with components "x" and "dx". The first gives the value of `f`, and the
second gives the derivative of `f`.
}
\description{
Automatic differentiation
}
\examples{
f <- function(y, X, beta) { y - X \%*\% beta }
auto_diff(
  f, wrt = "beta",
  at = list(beta = c(5,6), X = matrix(1:4, 2, 2), y = c(2,3))
)

g <- function(X, Y) { X \%*\% Y }
X <- randn(2, 2)
Y <- randn(2, 2)
auto_diff(g, at = list(X = X, Y = Y))

}
