% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImageAnalyser.R
\name{checkIsotropy}
\alias{checkIsotropy}
\title{Check the isotropy of a sample}
\usage{
checkIsotropy(AFMImage, AFMImageAnalyser)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} to be analysed}

\item{AFMImageAnalyser}{an \code{\link{AFMImageAnalyser}} to perform the analysis}
}
\value{
an \code{\link{AFMImageAnalyser}} containing the directional variograms
}
\description{
\code{checkIsotropy} is used to check the isotropy of an \code{\link{AFMImage}}. 
A directional variogram is calculated for various directions. 
If the variogram is very similar for all the directions then the sample is isotropic.
}
\examples{
\dontrun{
library(AFM)
library(ggplot2)

data(AFMImageOfAluminiumInterface)
AFMImage<-extractAFMImage(AFMImageOfAluminiumInterface, 0, 0, 32)
AFMImageAnalyser<-new("AFMImageAnalyser", AFMImage= AFMImage, fullfilename = AFMImage@fullfilename)
AFMImageAnalyser<-checkIsotropy(AFMImage,AFMImageAnalyser)
varios<-AFMImageAnalyser@variogramAnalysis@directionalVariograms
p2 <- ggplot(varios, aes(x=dist, y=gamma,  
                         color= as.factor(dir.hor), shape=as.factor(dir.hor)))
p2 <- p2 + expand_limits(y = 0)
p2 <- p2 + geom_point()
p2 <- p2 + geom_line()
p2 <- p2 + ylab("semivariance (nm^2)")
p2 <- p2 + xlab("distance (nm)")
p2 <- p2 + ggtitle("Directional")
p2
}

}
\author{
M.Beauvais
}
