% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatreat.R
\name{datatreat}
\alias{datatreat}
\title{Organizes pedigree data in a chronological way}
\usage{
datatreat(data = NULL, n.max = 50, unk = 0, file = NULL, log = FALSE)
}
\arguments{
\item{data}{name of the pedigree data frame. Default=NULL.}

\item{n.max}{max number of iteractions to get the chronological order. Default = 50}

\item{unk}{the code of the data missing. Default=0.}

\item{file}{name of the file to be saved. Default=NULL.}

\item{log}{if TRUE print the interaction number to sort the individuals. Default = FALSE}
}
\value{
list with parental 1, parental 2, and real names of the individuals (key) also saves a txt file with the new chronological pedigree.
}
\description{
This function organizes pedigree data in a chronological way and return 3 lists: i) parental 1 values (numeric); ii) parental 2 values (numeric); iii) real names of the individuals. Also save a .txt file with new pedigree file.
}
\examples{
data(ped.mrode)
datatreat(ped.mrode)

}
\author{
Rodrigo R Amadeu, \email{rramadeu@ufl.edu}
}
