% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Counts.R
\name{read_AG_counts}
\alias{read_AG_counts}
\title{Read data table files containing count values}
\usage{
read_AG_counts(
  file,
  verbose = FALSE,
  header = FALSE,
  header_timestamp_format = "\%m/\%d/\%Y \%H:\%M:\%S",
  ...
)
}
\arguments{
\item{file}{A character scalar giving path to an automatically-generated csv
file with count values}

\item{verbose}{A logical scalar: Print processing updates?}

\item{header}{A logical scalar: Are variable names contained in first row of
file?}

\item{header_timestamp_format}{character. Space delimited format of the date
and time in the file header (default is \code{\%m/\%d/\%Y \%H:\%M:\%S})}

\item{...}{Further arguments passed to \code{data.table::fread}}
}
\value{
A data frame reflecting the data contained in the csv file
}
\description{
Read data table files containing count values
}
\examples{
AG_counts <- read_AG_counts(
  system.file(
    "extdata",
    "example1sec.csv",
    package = "AGread"
  ),
  header = TRUE
)
head(AG_counts)

}
