% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHPtools.R
\name{sensitivity}
\alias{sensitivity}
\title{Compute Sensitivity}
\usage{
sensitivity(PCM, typePCM = TRUE)
}
\arguments{
\item{PCM}{A pairwise comparison matrix}

\item{typePCM}{boolean flag indicating if the first argument is a PCM or a
vector of upper triangular elements}
}
\value{
The average Spearman's rank correlation between the principal
eigenvectors of the input and the perturbed 'PCMs'
}
\description{
This function returns a sensitivity measure for an input
pairwise comparison matrix, PCM. Sensitivity is measured by Monte Carlo
simulation of 500 PCMs which are perturbations of the input PCM. The
perturbation algorithm makes a random choice from one of the 5 closest
items in the Fundamental Scale \{1/9, 1/8, ..... 1/2, 1, 2, ..... 8, 9\}
for each element in the PCM, ensuring the the pairwise reciprocity is
maintained. The sensitivity measure is the average Spearman's rank
correlation of the vector of ranks of the principal eigenvectors of
(i) the input PCM and (ii) the perturbed PCM. The average of the 500 such
rank correlations is reported as the measure of sensitivity.
}
\examples{
revcons1 <- revisedConsistency(matrix(
                 c(1,1/4,1/4,7,1/5, 4,1,1,9,1/4, 4,1,1,8,1/4,
                 1/7,1/9,1/8,1,1/9, 5,4,4,9,1), nrow=5, byrow=TRUE))
revcons1
sensitivity2 <- sensitivity(matrix(
                 c(1,7,1,9,8, 1/7,1,1/6,7,9, 1,6,1,9,9, 1/9,1/7,1/9,1,5,
                 1/8,1/9,1/9,1/5,1), nrow=5, byrow=TRUE))
sensitivity2
}
