% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_est_parameters_MSD_SAM_interval}
\alias{get_est_parameters_MSD_SAM_interval}
\title{Construct 95\% confidence interval}
\usage{
get_est_parameters_MSD_SAM_interval(
  param_uq_range,
  model_name,
  d_input,
  msd_fn = NA
)
}
\arguments{
\item{param_uq_range}{lower and upper bound for natural logorithm of
parameters in the fitted model using \code{AIUQ} method in \code{SAM} class}

\item{model_name}{model for constructing MSD, options from ('BM','OU',
'FBM','OU+FBM', 'user_defined')}

\item{d_input}{sequence of lag times}

\item{msd_fn}{user defined mean squared displacement structure (MSD), a
function of \code{param} parameters and \code{d_input} lag times}
}
\value{
A list of lower and upper bound for 95\% confidence interval
of estimated parameters and MSD for a given model.
}
\description{
This function construct the lower and upper bound for 95\% confidence interval
of estimated parameters and mean squared displacement(MSD) for a given model.
See 'References'.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
