% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WriteVoxelSpace.R
\docType{methods}
\name{writeVoxelSpace}
\alias{writeVoxelSpace}
\title{Write a voxel file}
\usage{
writeVoxelSpace(voxelSpace, outputFile)
}
\arguments{
\item{voxelSpace}{the object of class VoxelSpace to write}

\item{outputFile}{The path where to write the voxel file.}
}
\description{
write a voxel file out of a \code{\link{VoxelSpace-class}}
object.
}
\examples{
\dontrun{
# load a voxel file
vox <- readVoxelSpace(system.file("extdata", "als_sample.vox", package = "AMAPVox"))
# set max PAD to 5
vox@voxels[, PadBVTotal:=max(PadBVTotal, 5, na.rm = TRUE)]
# write updated voxel file
writeVoxelSpace(vox, tempfile("pattern"="amapvox_", fileext=".vox"))
}
}
\seealso{
\code{\link{readVoxelSpace}}
}
