% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.tbl_df}
\alias{print.tbl}
\alias{print.data.table}
\title{Printing Data Tables and Tibbles}
\usage{
\method{print}{tbl_df}(x, nmax = 10, header = TRUE, row.names = TRUE,
  right = FALSE, width = 1, na = "<NA>", ...)

\method{print}{tbl}(x, ...)

\method{print}{data.table}(x, print.keys = FALSE, ...)
}
\arguments{
\item{x}{object of class \code{data.frame}.}

\item{nmax}{amount of rows to print in total. When the total amount of rows exceeds this limit, the first and last \code{nmax / 2} rows will be printed. Use \code{nmax = NA} to print all rows.}

\item{header}{print header with information about data size and tibble grouping}

\item{row.names}{logical (or character vector), indicating whether (or
    what) row names should be printed.}

\item{right}{logical, indicating whether or not strings should be
    right-aligned.  The default is right-alignment.}

\item{width}{amount of white spaces to keep between columns, must be at least 1}

\item{na}{value to print instead of NA}

\item{...}{optional arguments to \code{print} or \code{plot} methods.}

\item{print.keys}{print keys for \code{data.table}}
}
\description{
Print a data table or tibble. It prints: \cr- The \strong{first and last rows} like \code{data.table}s are printed by the \code{data.table} package,\cr- A \strong{header} and \strong{left aligned text} like \code{tibble}s are printed by the \code{tibble} package with info about grouped variables,\cr- \strong{Unchanged values} and \strong{support for row names} like \code{data.frame}s are printed by the \code{base} package.
}
\examples{
# more reliable data view:
library(dplyr)
starwars
print(starwars, width = 3)

# This is how the tibble package prints since v1.4.0:
# (mind the quite unfamiliar underscores and ending dots)
tibble(now_what = c(1.2345, 2345.67, 321.456)) \%>\% tibble:::print.tbl_df()

# This is how this AMR package prints:
# (every number shown as you would expect)
tibble(now_what = c(1.2345, 2345.67, 321.456))

# also supports info about groups (look at header)
starwars \%>\% group_by(homeworld, gender)
}
