% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_apa_list.R
\name{plot.apa_list}
\alias{plot.apa_list}
\title{plot APA-maps}
\usage{
\method{plot}{apa_list}(
  x,
  subset = NULL,
  color_map = 1,
  tree_size_column = attr(x, "apa_config")$weight_column,
  tree_size_scale = 1,
  pal = sf::sf.colors,
  single_plots = FALSE,
  add_legend = TRUE,
  critical = "#FF000033",
  add = FALSE,
  cex = graphics::par("cex"),
  add_subplot = FALSE,
  add_plot_id_values = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{apa_list}-object.}

\item{subset}{The subset of APA-maps in \code{apa_list} that will be plotted
(see \link{subset.apa_list}).}

\item{color_map}{If \code{numeric} or \code{character}, this argument
specifies which aggregation class should be used for coloring APA-patches
(see \code{\link[=apa_add_agg_class]{apa_add_agg_class()}}). By supplying a \code{data.frame}, a custom color
scheme can be specified. The first column of the \code{data.frame} needs to
match with a categorical column in \code{tree_dat} and the second column
specifies the colors.}

\item{tree_size_column}{Column name in \code{tree_dat} that is used to adjust
point sizes of tree locations. If this column is a metric units object, it
is scaled to meters to match the units of the axes.}

\item{tree_size_scale}{If \code{tree_size_column} is a metric units object,
it is multiplied with \code{tree_size_scale}. Otherwise,
\code{tree_size_scale} specifies the size of the largest point in meters.}

\item{pal}{If no \code{color_map} is provided, this color palette function is
used for coloring. specified here.}

\item{single_plots}{Should the APA-maps be plotted as individual plots
(\code{TRUE}) or should all APA-maps be plotted in a single diagram
(\code{FALSE}, default)?}

\item{add_legend}{If \code{TRUE} (default), a legend will be plotted.}

\item{critical}{A color to shade the critical area close to the plot borders
that may be influenced by an edge effect.}

\item{add}{If \code{FALSE} (default), the plot will be standalone, otherwise
it will be added to the currently active plot.}

\item{cex}{Character expansion factor for labels (legend, titles)}

\item{add_subplot}{If \code{TRUE}, subplots that were added via
\link{apa_add_subplot_dat} will be added to the plot (default is \code{FALSE}).}

\item{add_plot_id_values}{If \code{TRUE} (default), plot id's will be added
as title.}

\item{...}{not implemented.}
}
\description{
APA-maps that are stored in an \code{APA-list}-object are being plotted.
}
\examples{
library(APAtree)
data(tree_enrico, package = "APAtree")
data(plot_enrico, package = "APAtree")
data(subplot_enrico, package = "APAtree")

tree_enrico$height_class <- cut(tree_enrico$height, breaks = seq(0, 40, 4))

# only calculating an apa_list for two plots and with a coarse resolution of 1 m
# to save time.
apa_list_enrico <- 
  apa_list(plot_dat = subset(plot_enrico, id_plot \%in\% c("5.2", "8.2")), 
           tree_dat = tree_enrico,
           plot_id_column = "id_plot",
           tree_id_column = "id_tree",
           weight_column = "crown_radius_95",
           agg_class_column = c("species", "height_class"),
           res = 1,
           apa_polygon = TRUE)

# plot all APA-maps in an apa_list:
plot(apa_list_enrico)

# choose a different palette for plotting
plot(apa_list_enrico, pal = rainbow)

# choose a custom color scheme
color_map <- 
  data.frame(species = c("Fagus sylvatica", "Pseudotsuga menziesii"),
             species_color = c("#7d5831", "#bcc746"))
plot(apa_list_enrico, color_map = color_map)
}
