% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialPointsCellCodes.R
\name{spatialPointsCellCodes}
\alias{spatialPointsCellCodes}
\title{Add cell identifiers to SpatialPoints as in INSPIRE Specification}
\usage{
spatialPointsCellCodes(points, dim = 1000, layers = 1)
}
\arguments{
\item{points}{object of class "SpatialPoints" or "SpatialPointsDataFrame".}

\item{dim}{a single integer specifying the initial cell sizes, defaults to
1km.}

\item{layers}{a single integer specifying the number of divisions of the
initial cells, defaults to 1.}
}
\value{
A "SpatialPointsDataFrame" containing all the points given. For
each point a cellCode and cellNum identify the cell to which the point belongs.\cr
CellCode is a text string, composed of cell size and cell coordinates.
Cell codes start with a cell size prefix. The cell size is denoted in meter (m)
for cell sizes below 1000 m and kilometer (km) for cell sizes from 1000 m and
above.\cr
The cellNum is a sequence identifying the different partitions of the main
cell in which the point resides.
}
\description{
\code{spatialPointsCellCodes} returns a SpatialPointsDataFrame with identifiers
(CellCode and CellNum) for each point as in INSPIRE Specification on Geographical
Grid Systems.
}
\details{
INSPIRE coding system for point identifiers\cr
The objective of the coding system is to generate unique identifiers for each
point, for any of the recommended resolutions.\cr
The cellCode is a text string, composed of cell size and cell coordinates.
Cell codes start with a cell size prefix. The cell size is denoted in meter (m)
for cell sizes below 1000 m and kilometre (km) for cell sizes from 1000 m and
above.\cr
Examples: a 100 meter cell has an identifier starting with “100m”, the
identifier  of a 10000 meter cell starts with “10km”.\cr
The coordinate part of the cell code reflects the distance of the lower left
grid cell corner from the false origin of the CRS. In order to reduce the
length of the string, Easting (E) and Northing (N) values are divided by
10n (n is the number of zeros in the cell size value). Example for a cell
size of 10000 meters: The number of zeros in the cell size value is 4.
The resulting divider for Easting and Northing values is 104 = 10000.\cr
The cellNum is a sequence of concatenated integers identifying all the
hierarchical partitions of the main cell in which the point resides.
For instance, the cellNum of the top right cell would be 416 (fourth
in first partition, sixteenth in second partition)\cr
\if{html}{\figure{CellNum.jpg}{options: width=200 alt="Hyerarchical CellNums"}}
\if{latex}{\figure{CellNum.jpg}{options: width=4cm}}
}
\examples{
data("BarcelonaPop")
BarcelonaPop.IDs<-spatialPointsCellCodes(BarcelonaPop)
BarcelonaPop.IDs.10km<-spatialPointsCellCodes(BarcelonaPop, 10000, 3)

}
\seealso{
\itemize{
  \item{
   D2.8.I.2 INSPIRE Specification on Geographical Grid Systems – Guidelines
   \url{https://inspire.ec.europa.eu/documents/Data_Specifications/INSPIRE_Specification_GGS_v3.0.1.pdf}
  }
  \item{
   EEA reference grid dataset
   \url{https://data.europa.eu/euodp/data/dataset/data_eea-reference-grids-2}
  }
}
}
