% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARpMMEC.est.R
\name{ARpMMEC.est}
\alias{ARpMMEC.est}
\title{Autoregressive Censored Mixed Effects Models}
\usage{
ARpMMEC.est(
  y,
  x,
  z,
  tt,
  cc,
  nj,
  Arp = 1,
  beta0 = NULL,
  sigma0 = NULL,
  D0 = NULL,
  pi0 = NULL,
  typeModel = "L",
  cens.type = "left",
  LI = NULL,
  LS = NULL,
  MaxIter = 200,
  error = 1e-04,
  Prev = FALSE,
  step = NULL,
  isubj = NULL,
  xpre = NULL,
  zpre = NULL
)
}
\arguments{
\item{y}{Vector \code{1 x n} of censored responses, where \code{n} is the sum of the number of observations of each individual}

\item{x}{Design matrix of the fixed effects of order \code{n x s}, corresponding to vector of fixed effects.}

\item{z}{Design matrix of the random effects of order\code{n x b}, corresponding to vector of random effects.}

\item{tt}{Vector \code{1 x n} with the time the measurements were made, where \code{n} is the total number of measurements for all individuals.}

\item{cc}{Vector of censoring indicators of length \code{n}, where \code{n} is the total of observations. For each observation: \code{0} if non-censored, \code{1} if censored.}

\item{nj}{Vector \code{1 x m} with the number of observations for each subject,  where \code{m} is the total number of individuals.}

\item{Arp}{Order of the autoregressive process. Must be a positive integer value. To consider a model uncorrelated use \code{UNC}.}

\item{beta0}{Initial values for the vector of fixed effects. If it is not indicated it will be provided automatically. Default is \code{NULL}}

\item{sigma0}{Initial values for sigma. If it is not indicated it will be provided automatically. Default is \code{NULL}}

\item{D0}{Initial values for the  covariance matrix  for the random effects. If it is not indicated it will be provided automatically. Default is \code{NULL}}

\item{pi0}{Initial values for the vector for autoregressive coefficients pi's. If it is not indicated it will be provided automatically. Default is \code{NULL}}

\item{typeModel}{\code{L} for linear model and \code{NL} for nolinear model. Default is \code{L}}

\item{cens.type}{\code{left} for left censoring, \code{right} for right censoring and \code{interval} for intervalar censoring. Default is \code{left}}

\item{LI}{Vector censoring lower limit indicator of length \code{n}. For each observation: \code{0} if non-censored, \code{-inf} if censored. It is only indicated for when \code{cens.type} is \code{both}. Default is \code{NULL}}

\item{LS}{Vector censoring upper limit indicator of length \code{n}. For each observation: \code{0} if non-censored, \code{inf} if censored.It is only indicated for when \code{cens.type} is \code{both}. Default is \code{NULL}}

\item{MaxIter}{The maximum number of iterations of the EM algorithm. Default is \code{200}}

\item{error}{The convergence maximum error. Default is \code{0.0001}}

\item{Prev}{Indicator of the prediction process. Default is \code{FALSE}}

\item{step}{Number of steps for prediction. Default is \code{NULL}}

\item{isubj}{Vector indicator of subject included in the prediction process. Default is \code{NULL}}

\item{xpre}{Design matrix of the fixed effects to be predicted. Default is \code{NULL}.}

\item{zpre}{Design matrix of the random effects to be predicted. Default is \code{NULL}.}
}
\value{
returns list of class \dQuote{ARpMMEC}:
\item{FixEffect}{Data frame with: estimate, standars erros and confidence intervals of the fixed effects.}
\item{Sigma2}{Data frame with: estimate, standars erros and confidence intervals  of the variance of the white noise process.}
\item{Phi}{Data frame with: estimate, standars erros and confidence intervals  of the autoregressive parameters.}
\item{RnEffect}{Data frame with: estimate, standars erros and confidence intervals  of the random effects.}
\item{Est}{Vector of parameters estimate (fixed Effects, sigma2, phi, random effects).}
\item{SE}{Vector of the standard errors of (fixed Effects, sigma2, phi, random effects).}
\item{loglik}{Log-likelihood value.}
\item{AIC}{Akaike information criterion.}
\item{BIC}{Bayesian information criterion.}
\item{AICc}{Corrected Akaike information criterion.}
\item{iter}{Number of iterations until convergence.}
\item{MI}{Information matrix}
\item{Prev}{Predicted values (if xpre and zpre is not \code{NULL}).}
\item{time}{Processing time.}
}
\description{
This functino fits left, right or intervalar censored mixed-effects linear model, with autoregressive errors of order \code{p}, using the EM algorithm. It returns estimates, standard errors and prediction of future observations.
}
\examples{
\dontrun{
 p.cens   = 0.1
 m           = 50
 D = matrix(c(0.049,0.001,0.001,0.002),2,2)
 sigma2 = 0.30
 phi    = c(0.48,-0.2)
 beta   = c(1,2,1)
 nj=rep(6,50)
 tt=rep(seq(1:6),50)
 x<-matrix(runif(sum(nj)*length(beta),-1,1),sum(nj),length(beta))
 z<-matrix(runif(sum(nj)*dim(D)[1],-1,1),sum(nj),dim(D)[1])
 data=ARpMMEC.sim(m,x,z,tt,nj,beta,sigma2,D,phi,p.cens)
 attach(data, warn.conflicts = F)
 Arp    = 2

 teste1=ARpMMEC.est(y_cc,x,z,tt,cc,nj,Arp,MaxIter = 10)

 xx=matrix(runif(6*length(beta),-1,1),6,length(beta))
 zz=matrix(runif(6*dim(D)[1],-1,1),6,dim(D)[1])
 isubj=c(1,4,5)
 teste2=ARpMMEC.est(y_cc,x,z,tt,cc,nj,Arp,MaxIter=10,Prev=TRUE,step=2,isubj=isubj,xpre=xx,zpre=zz)
 teste2$Prev
}
}
