% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Darwent.r
\name{plot_Darwent}
\alias{plot_Darwent}
\title{Plots participants' SLEEP/WAKE intervals.}
\usage{
plot_Darwent(x, datebreaks = "12 hour", base = "TRUE", acolor, decal,
  export = FALSE, show_plot = TRUE, si, tz = "UTC", tz2, homeTZ,
  shade = FALSE, local.shade = FALSE, ...)
}
\arguments{
\item{x}{a dataframe.}

\item{datebreaks}{is the distance between breaks in the x-axis. "12 hour" by default.}

\item{base}{matches the participants at the same start date.}

\item{acolor}{specifies the colors for the interval_type.}

\item{decal}{is a parameter for shifting the start date.}

\item{export}{if TRUE, it will export the data as CSV.}

\item{show_plot}{logical to produce the plot or not.}

\item{si}{defines the size of the geom_segment, 8 by default.}

\item{tz}{is the times zone. tz = "UTC" by default.}

\item{tz2}{an additional time zone used for a secondary x-axis.}

\item{homeTZ}{a data frame containing the all subject_IDs in x and the time zone. It is used for the
home night shading.}

\item{shade}{if TRUE, it will draw in light green the home night period. FALSE by default.}

\item{local.shade}{(deprecated) if TRUE, it will draw in gray the local night period. FALSE by default.}

\item{...}{optional parameters.}
}
\value{
a plot.
}
\description{
Plots participants' SLEEP/WAKE intervals.
}
\examples{
library("dplyr")
library("lubridate")
data(act)
dat <- act \%>\% group_by(subject_ID) \%>\%
  mutate(start = min(datime_start)) \%>\%
  ungroup \%>\% filter(datime_start <= start + days(10), interval_type != "ACTIVE")
plot_Darwent(dat,  acolor = c("#D55E00", "black", "#56B4E9"),
                  tz2 = "Pacific/Auckland",
                  si = c(4, 3, 2.5))

# Adding the 'home' night shade
# creating a data frame with the home time zone of the individuals
homeTZ = data.frame(subject_ID = unique(dat$subject_ID),
                    TZ = rep("Pacific/Auckland", 5),
                    stringsAsFactors = FALSE)
plot_Darwent(dat, acolor = c("#D55E00", "black", "#56B4E9"),
             si = c(4, 3, 2.5),
             tz = "UTC", tz2 = "Pacific/Auckland", shade = TRUE,
             homeTZ = homeTZ)


}
