% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_Darwent.r
\name{plot_long}
\alias{plot_long}
\title{Plots with-in participant activity intervals (SLEEP, REST, ACTIVE, etc) in 24 hour sections.}
\usage{
plot_long(dat, acolor, si, tz = "UTC", tz2, sp = "00:00:00",
  with_date = FALSE, alphas = 1, hourbreaks = 5, ...)
}
\arguments{
\item{dat}{a dataframe.}

\item{acolor}{the color of the lines.}

\item{si}{defines the size of the geom_segment, 1.25 by default.}

\item{tz}{the time zone.}

\item{tz2}{an additional time zone.}

\item{sp}{the starting point in the x-axis. Set as 00:00:00 by default.}

\item{with_date}{allows adding the cutpoint date to the y-axis. with_date = FALSE by default.}

\item{alphas}{is the transparency.}

\item{hourbreaks}{is the number of labels on the x-axis.}

\item{...}{Optional parameters.}
}
\value{
a plot.
}
\description{
Plots with-in participant activity intervals (SLEEP, REST, ACTIVE, etc) in 24 hour sections.
}
\details{
The date-time data in the data frame dat will keep time zone.
The argument tz and tz2 are used to specify the time in the x-axis.
}
\examples{
library("dplyr")
data(act)
act[act$subject_ID == 1 & act$interval_type != "ACTIVE",] \%>\%
plot_long(., si = c(3, 2.5, 2, 1.5),
             tz2 = "Pacific/Auckland",
             acolor = c("#D55E00", "black", "#56B4E9"))
}
