% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\docType{data}
\name{med.events}
\alias{med.events}
\title{Example medication events records for 100 patients.}
\format{A data frame with 1080 rows and 5 variables:
\describe{
  \item{PATIENT_ID}{\emph{integer} here; patient unique identifier. Can also
  be \emph{string}}.
  \item{DATE}{\emph{character};the medication event date, by default in the
  mm/dd/yyyy format. It may represent a prescribing or dispensing date.}
  \item{PERDAY}{\emph{integer}; the daily dosage prescribed for the
  medication supplied at this medication event (i.e. how many doses should
  be taken daily according to the prescription). This column is optional,
  as it is not considered in all functions but may be relevant for specific
  research or clinical contexts. All values should be > 0.}
  \item{CATEGORY}{\emph{character}; the medication type, here two placeholder
  labels, 'medA' and 'medB'. This is a researcher-defined classification
  depending on study aims (e.g., based on therapeutic use, mechanism of
  action, chemical molecule, or pharmaceutical formulation). This column is
  optional, as it is not considered in all functions but may be relevant for
  specific research or clinical contexts.}
  \item{DURATION}{\emph{integer}; the medication event duration in days (i.e.
  how many days the mediation supplied would last if used as prescribed);
  may be available in the extraction or computed based on quantity supplied
  (the number of doses prescribed or dispensed on that occasion) and daily
  dosage. All values should be > 0.}
}}
\usage{
med.events
}
\description{
An artificial dataset containing medication events (one per row) for 100
patients (1080 events in total). This is the dataset format appropriate for
medication adherence analyses performed with the R package AdhereR.
Medication events represent individual records of prescribing or dispensing
a specific medication for a patient at a given date. Dosage and medication
type is optional (only needed if calculation of adherence or persistence
takes into account changes in dosage and type of medication).
}
\keyword{datasets}
