% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{map.event.coords.to.plot}
\alias{map.event.coords.to.plot}
\title{Map from event to plot coordinates.}
\usage{
map.event.coords.to.plot(
  x = NA,
  y = NA,
  x.is.Date = FALSE,
  x.date.format = "\%m/\%d/\%Y",
  adjust.for.earliest.date = TRUE,
  plot.type = c("baseR", "SVG")[1],
  suppress.warnings = FALSE
)
}
\arguments{
\item{x}{The \emph{x} coordinate in the event space, either a \code{number} giving the
number of days since the earliest plotted date, or a \code{Date} or a \code{string} in
the format given by the \emph{x.date.format} parameter giving the actual calendar date.}

\item{y}{The \emph{y} coordinate in the event space, thus a \code{number} giving the
plot row.}

\item{x.is.Date}{A \code{logical}, being \code{TRUE} if \emph{x} is a string giving the
date in the \emph{x.date.format} format.}

\item{x.date.format}{A \code{string} giving the format of the \emph{x} date, if
\emph{x.is.Date} id \code{TRUE}.}

\item{adjust.for.earliest.date}{A \code{logical} which is \code{TRUE} if \emph{x} is a
calendar date that must be adjusted for the earliest plotted date (by default
\code{TRUE}).}

\item{plot.type}{Can be either "baseR" or "SVG" and specifies to which type of plotting
the mapping applies.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}
}
\value{
A numeric vector with \emph{x} and \emph{y} components giving the plotting
coordinates, or \code{NULL} in case of error.
}
\description{
Maps the (x,y) coordinates in the event space to the plotting space.
}
\details{
This is intended for advanced users only.
In the event space, the \emph{x} coordinate can be either given as the number of
days since the first plotted event, or as an actual calendar date (either as a
\code{Date} object or a string with a given format; a date may or may not be corrected
relative to the first displayed date). On the \emph{y} coordinate, the plotting is
divided in equally spaced rows, each row corresponding to a single event or an element
of a partial CMA plot (one can specify in between rows using fractions). Any or both of
\emph{x} and \emph{y} can be missing.
}
\examples{
cma7 <- CMA7(data=med.events[med.events$PATIENT_ID \%in\% c(1,2),],
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             followup.window.start=0,
             followup.window.start.unit="days",
             followup.window.duration=2*365,
             followup.window.duration.unit="days",
             observation.window.start=30,
             observation.window.start.unit="days",
             observation.window.duration=365,
             observation.window.duration.unit="days",
             date.format="\%m/\%d/\%Y",
             summary="Base CMA");
plot(cma7);
# Add a transparent blue rect:
rect(map.event.coords.to.plot(x=270),
     get.event.plotting.area()["y.min"]-1,
     map.event.coords.to.plot(x="03/15/2037", x.is.Date=TRUE, x.date.format="\%m/\%d/\%Y"),
     get.event.plotting.area()["y.max"]+1,
     col=adjustcolor("blue",alpha.f=0.5), border="blue");
}
