% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AdjBQR.R
\name{BQR}
\alias{BQR}
\title{Adjusted Bayesian Quantile Regression}
\usage{
BQR(y, x, tau, niter = 20000, burn_in = 4000, prop_cov = NULL,
  level = 0.9)
}
\arguments{
\item{y}{the response vector}

\item{x}{the design matrix. If the first column of x is not all ones, a column of ones will be added.}

\item{tau}{the quantile level of interest}

\item{niter}{integer: number of iterations to run the chain for. Default 20000.}

\item{burn_in}{integer: discard the first burn_in values. Default 100.}

\item{prop_cov}{covariance matrix giving the covariance of the proposal distribution.
This matrix need not be positive definite.
If the covariance structure of the target distribution is known (approximately), it can be given here.
If not given, the diagonal will be estimated via the Fisher information matrix.}

\item{level}{nominal confidence level for the credible interval}
}
\value{
A list of the following commponents is returned

estpar: posterior mean of the regression coefficient vector

PSD: posterior standard deviation without adjustment

PSD.adj: posterior standard deviation with adjustment

CI.BAL: credible interval without adjustment

CI.BAL.adj: credible interval with adjustment

sig: estimated scale parameter

MCMCsize: effective size of the chain
}
\description{
Bayesian quantile regression
based on asymmetric Laplace likelihood
with posterior variance adjustment
}
\details{
The function returns the unadjusted and adjusted posterior standard deviation, and unadjusted and
adjusted credible intervals for Bayesian quantile regression based on asymmetric Laplace working likelihood.
}
\examples{
#A simulation example
library(AdjBQR)
n=200
set.seed(12368819)
x1 = rnorm(n)
x2 = rnorm(n)
y=2*x1+2*x2+rt(n,df=3)
x = cbind(1, x1, x2)
## Bayesian quantile regression based on asymmetric Laplace likelihood
BQR(y, x, tau=0.5, level=0.9)
}
\references{
Yang, Y., Wang, H. and He, X. (2015). Posterior inference in Bayesian quantile regression with asymmetric Laplace
  likelihood. International Statistical Review, 2015. doi: 10.1111/insr.12114.
}

