% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineups_advance_stats.R
\name{lineups_advance_stats}
\alias{lineups_advance_stats}
\title{Lineups advanced statistics}
\usage{
lineups_advance_stats(df1, m)
}
\arguments{
\item{df1}{Should be a Data Frame. This parameter has to be in the format provided by the lineups_advance_stats() function.}

\item{m}{should be a number. This parameter has to be the duration of a single game.}
}
\value{
Data frame with the following advanced statistics calculated
       \itemize{
                \item Offensive Rating (ORtg)
                \item Defensive Rating (DRtg)
                \item Net Rating (NetRtg)
                \item Pace (Pace)
                \item Three rating (3Par)
                \item True shooting percentage (TS\%)
                \item Efficiency Field Goals percentage (eFG\%)
                \item Assists percentage (AST\%)
                \item Offensive rebounds percentage (ORB\%)
                \item Defensive rebounds percentage (DRB\%)
                \item Total rebounds percentage (TRB\%)
                \item Turnover percentage (TOV\%)
        }
}
\description{
This function allows the calculation of advanced player statistics.
}
\details{
The function only works with the extended statistics of the lineups.
}
\examples{

df1 <-  data.frame("PG" = c("James","Rondo"),"SG" = c("Green","Caruso"),
"SF" = c("Caldwell","Kuzma"), "PF" = c("Davis","Davis"),
"C" = c("Howard ","Howard"),"MP" = c(7,1), "FG " = c(6,0),
"OppFG " = c(6,0), "FGA " = c(10,0),"OppFGA " = c(9,0),
"X3P  " = c(2,0),"Opp3P" = c(1,0),"X3PA" = c(4,0),"Opp3PA" = c(3,0),
"X2P" = c(4,0),"Opp2P " = c(5,0), "X2PA " = c(6,0),"Opp2PA " = c(8,0) ,
"FT " = c(0,0),"OppFT " = c(1,0), "FTA " = c(0,0),"OppFTA " = c(1,0),
"OppRB " = c(2,0),"OppOppRB " = c(1,0), "DRB" = c(4,0),"OppDRB" = c(1,0),
"TRB" = c(6,0),"OppTRB" = c(2,0), "AST " = c(5,0),"OppAST " = c(4,0),
"STL " = c(1,0),"OppSTL " = c(3,0), "BLK " = c(0,0),  "OppBLK " = c(1,0),
"TOppV " = c(5,2), "OppTOppV " = c(3,2),"PF" = c(1,0),"OppPF" = c(3,0),
"PLUS" = c(15,0),"MINUS" = c(14,3),"P/M" = c(1,-3))

m <- 48

lineups_advance_stats(df1,m)

}
