#' Dataset: corn
#'
#' @description A 3 x 2 factorial experiment was carried out to compare three
#' new corn hybrids considering the change in sowing density, being
#' 55 thousand or 65 thousand seeds per hectare. For this case,
#' the researcher is not interested in estimating values for other
#' densities, but only in verifying if one density differs from
#' the other. The experiment was carried out according to a
#' completely randomized design with 4 repetitions of each treatment.
#'
#'
#' @docType data
#'
#' @usage data(corn)
#'
#' @format data.frame containing data set
#'   \describe{
#'   \item{\code{A}}{Categorical vector with hybrids}
#'   \item{\code{B}}{Categorical vector with density}
#'   \item{\code{resp}}{Numeric vector with response}
#'   }
#' @keywords datasets
#' @seealso \link{enxofre}, \link{laranja}, \link{mirtilo}, \link{pomegranate}, \link{porco}, \link{sensorial}, \link{simulate1}, \link{simulate2}, \link{simulate3}, \link{tomate}, \link{weather}, \link{phao}, \link{passiflora}, \link{aristolochia}
#'
#' @examples
#' data(corn)
"corn"

