% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FAT3DBC_function.R
\name{FAT3DBC}
\alias{FAT3DBC}
\title{Analysis: DBC experiments in triple factorial}
\usage{
FAT3DBC(
  f1,
  f2,
  f3,
  block,
  response,
  norm = "sw",
  homog = "bt",
  alpha.f = 0.05,
  alpha.t = 0.05,
  quali = c(TRUE, TRUE, TRUE),
  mcomp = "tukey",
  transf = 1,
  constant = 0,
  names.fat = c("F1", "F2", "F3"),
  ylab = "Response",
  xlab = "",
  sup = NA,
  grau = NA,
  fill = "lightblue",
  theme = theme_classic(),
  angulo = 0,
  errorbar = TRUE,
  addmean = TRUE,
  family = "sans",
  dec = 3,
  geom = "bar",
  textsize = 12,
  angle.label = 0
)
}
\arguments{
\item{f1}{Numeric or complex vector with factor 1 levels}

\item{f2}{Numeric or complex vector with factor 2 levels}

\item{f3}{Numeric or complex vector with factor 3 levels}

\item{block}{Numerical or complex vector with blocks}

\item{response}{Numerical vector containing the response of the experiment.}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{quali}{Defines whether the factor is quantitative or qualitative (\emph{qualitative})}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD, Scott-Knott and Duncan)}

\item{transf}{Applies data transformation (\emph{default} is 1; for log consider 0)}

\item{constant}{Add a constant for transformation (enter value)}

\item{names.fat}{Allows labeling the factors 1, 2 and 3.}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{grau}{Degree of polynomial in case of quantitative factor (\emph{default} is 1)}

\item{fill}{Defines chart color (to generate different colors for different treatments, define fill = "trat")}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{angulo}{x-axis scale text rotation}

\item{errorbar}{Plot the standard deviation bar on the graph (In the case of a segment and column graph) - \emph{default} is TRUE}

\item{addmean}{Plot the average value on the graph (\emph{default} is TRUE)}

\item{family}{Font family}

\item{dec}{Number of cells}

\item{geom}{Graph type (columns or segments)}

\item{textsize}{Font size}

\item{angle.label}{label angle}
}
\value{
The analysis of variance table, the Shapiro-Wilk error normality test, the Bartlett homogeneity test of variances, the Durbin-Watson error independence test, multiple comparison test (Tukey, LSD, Scott-Knott or Duncan) or adjustment of regression models up to grade 3 polynomial, in the case of quantitative treatments. The column chart for qualitative treatments is also returned.For significant triple interaction only, no graph is returned.
}
\description{
Analysis of an experiment conducted in a randomized block design in a triple factorial scheme using analysis of variance of fixed effects.
}
\note{
The function does not perform multiple regression in the case of two or more quantitative factors. The bars of the column and segment graphs are standard deviation.

In the final output when transformation (transf argument) is different from 1, the columns resp and respo in the mean test are returned, indicating transformed and non-transformed mean, respectively.
}
\examples{
library(AgroR)
data(enxofre)
with(enxofre, FAT3DBC(f1, f2, f3, bloco, resp))
}
\references{
Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.

Ferreira, E. B., Cavalcanti, P. P., and Nogueira, D. A. (2014). ExpDes: an R package for ANOVA and experimental designs. Applied Mathematics, 5(19), 2952.

Mendiburu, F., and de Mendiburu, M. F. (2019). Package ‘agricolae’. R Package, Version, 1-2.
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{DIC}
\keyword{Factorial}
