% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_aqi.R
\name{monitor_aqi}
\alias{monitor_aqi}
\title{Calculate hourly NowCast-based AQI values}
\usage{
monitor_aqi(
  monitor,
  version = c("pm", "pmAsian", "ozone"),
  includeShortTerm = FALSE,
  NAAQS = c("PM2.5", "PM2.5_2024")
)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{version}{Name of the type of nowcast algorithm to be used.}

\item{includeShortTerm}{Logical specifying whether to alcluate preliminary
NowCast values starting with the 2nd hour.}

\item{NAAQS}{Version of NAAQS levels to use. See Note.}
}
\value{
A modified \code{mts_monitor} object containing AQI values. (A list
with \code{meta} and \code{data} dataframes.)
}
\description{
Nowcast and AQI algorithms are applied to the data in the
monitor object. A modified \code{mts_monitor} object is returned whre values
have been replaced with their Air Quality Index equivalents. See \link{monitor_nowcast}.
}
\note{
On February 7, 2024, EPA strengthened the National Ambient Air Quality
Standards for Particulate Matter (PM NAAQS) to protect millions of Americans
from harmful and costly health impacts, such as heart attacks and premature
death. Particle or soot pollution is one of the most dangerous forms of air
pollution, and an extensive body of science links it to a range of serious
and sometimes deadly illnesses. EPA is setting the level of the primary
(health-based) annual PM2.5 standard at 9.0 micrograms per cubic meter to
provide increased public health protection, consistent with the available
health science.
See \href{https://www.epa.gov/pm-pollution/final-reconsideration-national-ambient-air-quality-standards-particulate-matter-pm}{PM NAAQS update}.
}
\references{
\url{https://en.wikipedia.org/wiki/Nowcast_(Air_Quality_Index)}

\url{https://www.airnow.gov/aqi/aqi-basics/}
}
