% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pas_downloadParseRawData.R
\name{pas_downloadParseRawData}
\alias{pas_downloadParseRawData}
\title{Download synoptic data from PurpleAir}
\usage{
pas_downloadParseRawData(baseUrl = "https://www.purpleair.com/json")
}
\arguments{
\item{baseUrl}{base URL for synoptic data}
}
\value{
Dataframe of synoptic PurpleAir data.
}
\description{
Download and parse synoptic data from the Purple Air network
of particulate sensors.

The synoptic data provides a view of the entire Purple Air network and
includes both metadata and recent PM2.5 averages for each deployed sensor.
}
\examples{
\donttest{
library(AirSensor)

initializeMazamaSpatialUtils()

pas_raw <- pas_downloadParseRawData()

if ( interactive() ) {
  View(pas_raw[1:100,])
}
}
}
\references{
\href{https://www.purpleair.com/json}{json formatted PurpleAir data}
}
\seealso{
\link{pas_enhanceData}
}
