% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam}
\alias{SimParam}
\title{Simulation parameters}
\description{
Container for global simulation parameters. Saving this object 
as SP will allow it to be accessed by function defaults.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{recombRatio}}{ratio of genetic recombination in 
females relative to male}

\item{\code{nThreads}}{number of threads used on platforms with OpenMP support}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nChr}}{number of chromosomes}

\item{\code{nTraits}}{number of traits}

\item{\code{nSnpChips}}{number of SNP chips}

\item{\code{segSites}}{segregating sites per chromosome}

\item{\code{gender}}{is gender used for mating}

\item{\code{genMap}}{"matrix" of chromosome genetic maps}

\item{\code{femaleMap}}{"matrix" of chromosome genetic maps for 
females}

\item{\code{maleMap}}{"matrix" of chromosome genetic maps for 
males}

\item{\code{sepMap}}{are there seperate genetic maps for 
males and females}

\item{\code{femaleCentromere}}{position of centromere on female 
genetic map}

\item{\code{maleCentromere}}{position of centromere on male 
genetic map}

\item{\code{recombRatio}}{ratio of genetic recombination in 
females relative to male}

\item{\code{traits}}{list of trait}

\item{\code{snpChips}}{list of SNP chips}

\item{\code{potQtl}}{list of potential QTL segregating sites}

\item{\code{potSnp}}{list of potential SNP segregating sites}

\item{\code{lastId}}{last ID number assigned}

\item{\code{isTrackPed}}{is pedigree being tracked}

\item{\code{pedigree}}{pedigree matrix for all individuals}

\item{\code{isTrackRec}}{is recombination being tracked}

\item{\code{recHist}}{list of historic recombination events}

\item{\code{varA}}{additive genetic variance in founderPop}

\item{\code{varG}}{total genetic variance in founderPop}

\item{\code{varE}}{default error variance}

\item{\code{founderPop}}{the founder population used for scaling traits}

\item{\code{v}}{the interference parameter for a gamma model of recombination}

\item{\code{quadProb}}{the probability of quadrivalent formation}

\item{\code{version}}{the version of AlphaSimR used to generate this object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SimParam$new()}}
\item \href{#method-updateLastId}{\code{SimParam$updateLastId()}}
\item \href{#method-setTrackPed}{\code{SimParam$setTrackPed()}}
\item \href{#method-setTrackRec}{\code{SimParam$setTrackRec()}}
\item \href{#method-resetPed}{\code{SimParam$resetPed()}}
\item \href{#method-restrSegSites}{\code{SimParam$restrSegSites()}}
\item \href{#method-setGender}{\code{SimParam$setGender()}}
\item \href{#method-setMeiosis}{\code{SimParam$setMeiosis()}}
\item \href{#method-setVarE}{\code{SimParam$setVarE()}}
\item \href{#method-setCorE}{\code{SimParam$setCorE()}}
\item \href{#method-addSnpChip}{\code{SimParam$addSnpChip()}}
\item \href{#method-addStructuredSnpChip}{\code{SimParam$addStructuredSnpChip()}}
\item \href{#method-removeSnpChip}{\code{SimParam$removeSnpChip()}}
\item \href{#method-switchSnpChip}{\code{SimParam$switchSnpChip()}}
\item \href{#method-manAddSnpChip}{\code{SimParam$manAddSnpChip()}}
\item \href{#method-addTraitA}{\code{SimParam$addTraitA()}}
\item \href{#method-addTraitAD}{\code{SimParam$addTraitAD()}}
\item \href{#method-addTraitAG}{\code{SimParam$addTraitAG()}}
\item \href{#method-addTraitADG}{\code{SimParam$addTraitADG()}}
\item \href{#method-addTraitAE}{\code{SimParam$addTraitAE()}}
\item \href{#method-addTraitADE}{\code{SimParam$addTraitADE()}}
\item \href{#method-addTraitAEG}{\code{SimParam$addTraitAEG()}}
\item \href{#method-addTraitADEG}{\code{SimParam$addTraitADEG()}}
\item \href{#method-removeTrait}{\code{SimParam$removeTrait()}}
\item \href{#method-switchTrait}{\code{SimParam$switchTrait()}}
\item \href{#method-manAddTrait}{\code{SimParam$manAddTrait()}}
\item \href{#method-rescaleTraits}{\code{SimParam$rescaleTraits()}}
\item \href{#method-switchFounderPop}{\code{SimParam$switchFounderPop()}}
\item \href{#method-removeFounderPop}{\code{SimParam$removeFounderPop()}}
\item \href{#method-addToPed}{\code{SimParam$addToPed()}}
\item \href{#method-addToRec}{\code{SimParam$addToRec()}}
\item \href{#method-switchGenMap}{\code{SimParam$switchGenMap()}}
\item \href{#method-switchFemaleMap}{\code{SimParam$switchFemaleMap()}}
\item \href{#method-switchMaleMap}{\code{SimParam$switchMaleMap()}}
\item \href{#method-clone}{\code{SimParam$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$new(founderPop)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-updateLastId"></a>}}
\subsection{Method \code{updateLastId()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$updateLastId(lastId)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setTrackPed"></a>}}
\subsection{Method \code{setTrackPed()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setTrackPed(isTrackPed, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setTrackRec"></a>}}
\subsection{Method \code{setTrackRec()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setTrackRec(isTrackRec, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resetPed"></a>}}
\subsection{Method \code{resetPed()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$resetPed(lastId = 0L)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restrSegSites"></a>}}
\subsection{Method \code{restrSegSites()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$restrSegSites(
  maxQtl = 0,
  maxSnp = 0,
  overlap = FALSE,
  minSnpFreq = NULL,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setGender"></a>}}
\subsection{Method \code{setGender()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setGender(gender, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setMeiosis"></a>}}
\subsection{Method \code{setMeiosis()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setMeiosis(v = NULL, ratio = NULL, quadProb = NULL, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setVarE"></a>}}
\subsection{Method \code{setVarE()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setVarE(h2 = NULL, H2 = NULL, varE = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setCorE"></a>}}
\subsection{Method \code{setCorE()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setCorE(corE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addSnpChip"></a>}}
\subsection{Method \code{addSnpChip()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addSnpChip(nSnpPerChr, minSnpFreq = NULL, refPop = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addStructuredSnpChip"></a>}}
\subsection{Method \code{addStructuredSnpChip()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addStructuredSnpChip(nSnpPerChr, structure, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeSnpChip"></a>}}
\subsection{Method \code{removeSnpChip()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$removeSnpChip(chips, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchSnpChip"></a>}}
\subsection{Method \code{switchSnpChip()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchSnpChip(lociMap, chip, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-manAddSnpChip"></a>}}
\subsection{Method \code{manAddSnpChip()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$manAddSnpChip(lociMap, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitA"></a>}}
\subsection{Method \code{addTraitA()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitA(
  nQtlPerChr,
  mean = 0,
  var = 1,
  corA = NULL,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAD"></a>}}
\subsection{Method \code{addTraitAD()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAD(
  nQtlPerChr,
  mean = 0,
  var = 1,
  meanDD = 0,
  varDD = 0,
  corA = NULL,
  corDD = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAG"></a>}}
\subsection{Method \code{addTraitAG()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varGxE = 1e-06,
  varEnv = 0,
  corA = NULL,
  corGxE = NULL,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitADG"></a>}}
\subsection{Method \code{addTraitADG()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varEnv = 1e-06,
  varGxE = 1e-06,
  meanDD = 0,
  varDD = 0,
  corA = NULL,
  corDD = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAE"></a>}}
\subsection{Method \code{addTraitAE()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAE(
  nQtlPerChr,
  mean = 0,
  var = 1,
  relAA = 0,
  corA = NULL,
  corAA = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitADE"></a>}}
\subsection{Method \code{addTraitADE()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADE(
  nQtlPerChr,
  mean = 0,
  var = 1,
  meanDD = 0,
  varDD = 0,
  relAA = 0,
  corA = NULL,
  corDD = NULL,
  corAA = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitAEG"></a>}}
\subsection{Method \code{addTraitAEG()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAEG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  relAA = 0,
  varGxE = 1e-06,
  varEnv = 0,
  corA = NULL,
  corAA = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addTraitADEG"></a>}}
\subsection{Method \code{addTraitADEG()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADEG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varEnv = 1e-06,
  varGxE = 1e-06,
  meanDD = 0,
  varDD = 0,
  relAA = 0,
  corA = NULL,
  corDD = NULL,
  corAA = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeTrait"></a>}}
\subsection{Method \code{removeTrait()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$removeTrait(traits, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchTrait"></a>}}
\subsection{Method \code{switchTrait()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchTrait(lociMap, trait, varA = NULL, varG = NULL, force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-manAddTrait"></a>}}
\subsection{Method \code{manAddTrait()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$manAddTrait(
  lociMap,
  varA = NA_real_,
  varG = NA_real_,
  varE = NA_real_,
  force = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rescaleTraits"></a>}}
\subsection{Method \code{rescaleTraits()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$rescaleTraits(
  mean = 0,
  var = 1,
  varEnv = 0,
  varGxE = 1e-06,
  useVarA = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchFounderPop"></a>}}
\subsection{Method \code{switchFounderPop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchFounderPop(founderPop)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-removeFounderPop"></a>}}
\subsection{Method \code{removeFounderPop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$removeFounderPop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addToPed"></a>}}
\subsection{Method \code{addToPed()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addToPed(lastId, mother, father, isDH)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addToRec"></a>}}
\subsection{Method \code{addToRec()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addToRec(hist)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchGenMap"></a>}}
\subsection{Method \code{switchGenMap()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchGenMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchFemaleMap"></a>}}
\subsection{Method \code{switchFemaleMap()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchFemaleMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-switchMaleMap"></a>}}
\subsection{Method \code{switchMaleMap()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchMaleMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
