% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyploids.R
\name{reduceGenome}
\alias{reduceGenome}
\title{Create individuals with reduced ploidy}
\usage{
reduceGenome(
  pop,
  nProgeny = 1,
  useFemale = TRUE,
  keepParents = TRUE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of 'Pop' superclass}

\item{nProgeny}{total number of progeny per individual}

\item{useFemale}{should female recombination rates be used.}

\item{keepParents}{should previous parents be used for mother and 
father.}

\item{simParam}{an object of 'SimParam' class}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Creates new individuals from gametes. This function 
was created to model the creation of diploid potatoes from 
tetraploid potatoes. It can be used on any population with an 
even ploidy level. The newly created individuals will have half 
the ploidy level of the originals and they will first undergo
a single round of meiosis.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Create individuals with reduced ploidy
pop2 = reduceGenome(pop, simParam=SP)

}
