% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyploids.R
\name{mergeGenome}
\alias{mergeGenome}
\title{Combine genomes of individuals}
\usage{
mergeGenome(females, males, crossPlan, simParam = NULL)
}
\arguments{
\item{females}{an object of \code{\link{Pop-class}} for female parents.}

\item{males}{an object of \code{\link{Pop-class}} for male parents.}

\item{crossPlan}{a matrix with two column representing
female and male parents. Either integers for the position in
population or character strings for the IDs.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
This function is designed to model the pairing of gametes. The male
and female individuals are treated as gametes, so the ploidy of newly 
created individuals will be the sum of it parents.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Cross individual 1 with individual 10
crossPlan = matrix(c(1,10), nrow=1, ncol=2)
pop2 = mergeGenome(pop, pop, crossPlan, simParam=SP)

}
