% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParam.R
\name{SimParam}
\alias{SimParam}
\title{Simulation parameters}
\description{
Container for global simulation parameters. Saving this object
as SP will allow it to be accessed by function defaults.
}
\note{
By default the founder population is the population used to
initalize the SimParam object. This population can be changed by
replacing the population in the founderPop slot. You must run
\code{\link{resetPop}} on any existing populations to obtain the
new trait values.
}
\examples{

## ------------------------------------------------
## Method `SimParam$new`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

## ------------------------------------------------
## Method `SimParam$setTrackPed`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setTrackPed(TRUE)

## ------------------------------------------------
## Method `SimParam$setTrackRec`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setTrackRec(TRUE)

## ------------------------------------------------
## Method `SimParam$resetPed`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
pop@id # 1:10

#Create another population after reseting pedigree
SP$resetPed()
pop2 = newPop(founderPop, simParam=SP)
pop2@id # 1:10

## ------------------------------------------------
## Method `SimParam$restrSegSites`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$restrSegSites(minQtlPerChr=5, minSnpPerChr=5)

## ------------------------------------------------
## Method `SimParam$setSexes`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setSexes("yes_sys")

## ------------------------------------------------
## Method `SimParam$addSnpChip`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addSnpChip(10)

## ------------------------------------------------
## Method `SimParam$addSnpChipByName`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addSnpChipByName(c("1_1","1_3"))

## ------------------------------------------------
## Method `SimParam$addTraitA`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)

## ------------------------------------------------
## Method `SimParam$addTraitAD`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAD(10, meanDD=0.5)

## ------------------------------------------------
## Method `SimParam$altAddTraitAD`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$altAddTraitAD(nQtlPerChr=10, mean=0, varA=1, varD=0.05, inbrDepr=0.2)

## ------------------------------------------------
## Method `SimParam$addTraitAG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAG(10, varGxE=2)

## ------------------------------------------------
## Method `SimParam$addTraitADG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitADG(10, meanDD=0.5, varGxE=2)

## ------------------------------------------------
## Method `SimParam$addTraitAE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAE(10, relAA=0.1)

## ------------------------------------------------
## Method `SimParam$addTraitADE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitADE(10)

## ------------------------------------------------
## Method `SimParam$addTraitAEG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAEG(10, varGxE=2)

## ------------------------------------------------
## Method `SimParam$addTraitADEG`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitADEG(10, meanDD=0.5, varGxE=2)

## ------------------------------------------------
## Method `SimParam$setVarE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
SP$setVarE(h2=0.5)

## ------------------------------------------------
## Method `SimParam$setCorE`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10, mean=c(0,0), var=c(1,1), corA=diag(2))
SP$setVarE(varE=c(1,1))
E = 0.5*diag(2)+0.5 #Positively correlated error
SP$setCorE(E)

## ------------------------------------------------
## Method `SimParam$rescaleTraits`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
meanG(pop)

#Change mean to 1
SP$rescaleTraits(mean=1)
\dontshow{SP$nThreads = 1L}
#Run resetPop for change to take effect
pop = resetPop(pop, simParam=SP)
meanG(pop)

## ------------------------------------------------
## Method `SimParam$setRecombRatio`
## ------------------------------------------------

#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setRecombRatio(2) #Twice as much recombination in females
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{nThreads}}{number of threads used on platforms with OpenMP support}

\item{\code{snpChips}}{list of SNP chips}

\item{\code{invalidQtl}}{list of segregating sites that aren't valid QTL}

\item{\code{invalidSnp}}{list of segregating sites that aren't valid SNP}

\item{\code{founderPop}}{founder population used for variance scaling}

\item{\code{finalizePop}}{function applied to newly created populations.
Currently does nothing and should only be changed by expert users.}

\item{\code{allowEmptyPop}}{if true, population arguments with nInd=0 will
return an empty population with a warning instead of an error.}

\item{\code{v}}{the crossover interference parameter for a gamma model of
recombination. A value of 1 indicates no crossover interference
(e.g. Haldane mapping function). A value of 2.6 approximates the
degree of crossover interference implied by the Kosambi mapping
function. (default is 2.6)}

\item{\code{p}}{the proportion of crossovers coming from a non-interfering
pathway. (default is 0)}

\item{\code{quadProb}}{the probability of quadrivalent pairing in an
autopolyploid. (default is 0)}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{traitNames}}{vector of trait names}

\item{\code{snpChipNames}}{vector of chip names}

\item{\code{traits}}{list of traits}

\item{\code{nChr}}{number of chromosomes}

\item{\code{nTraits}}{number of traits}

\item{\code{nSnpChips}}{number of SNP chips}

\item{\code{segSites}}{segregating sites per chromosome}

\item{\code{sexes}}{sexes used for mating}

\item{\code{sepMap}}{are there seperate genetic maps for
males and females}

\item{\code{genMap}}{"matrix" of chromosome genetic maps}

\item{\code{femaleMap}}{"matrix" of chromosome genetic maps for
females}

\item{\code{maleMap}}{"matrix" of chromosome genetic maps for
males}

\item{\code{centromere}}{position of centromeres genetic map}

\item{\code{femaleCentromere}}{position of centromeres on female
genetic map}

\item{\code{maleCentromere}}{position of centromeres on male
genetic map}

\item{\code{lastId}}{last ID number assigned}

\item{\code{isTrackPed}}{is pedigree being tracked}

\item{\code{pedigree}}{pedigree matrix for all individuals}

\item{\code{isTrackRec}}{is recombination being tracked}

\item{\code{recHist}}{list of historic recombination events}

\item{\code{haplotypes}}{list of computed IBD haplotypes}

\item{\code{varA}}{additive genetic variance in founderPop}

\item{\code{varG}}{total genetic variance in founderPop}

\item{\code{varE}}{default error variance}

\item{\code{version}}{the version of AlphaSimR used to generate this object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SimParam-new}{\code{SimParam$new()}}
\item \href{#method-SimParam-setTrackPed}{\code{SimParam$setTrackPed()}}
\item \href{#method-SimParam-setTrackRec}{\code{SimParam$setTrackRec()}}
\item \href{#method-SimParam-resetPed}{\code{SimParam$resetPed()}}
\item \href{#method-SimParam-restrSegSites}{\code{SimParam$restrSegSites()}}
\item \href{#method-SimParam-setSexes}{\code{SimParam$setSexes()}}
\item \href{#method-SimParam-setFounderHap}{\code{SimParam$setFounderHap()}}
\item \href{#method-SimParam-addSnpChip}{\code{SimParam$addSnpChip()}}
\item \href{#method-SimParam-addSnpChipByName}{\code{SimParam$addSnpChipByName()}}
\item \href{#method-SimParam-addStructuredSnpChip}{\code{SimParam$addStructuredSnpChip()}}
\item \href{#method-SimParam-addTraitA}{\code{SimParam$addTraitA()}}
\item \href{#method-SimParam-addTraitAD}{\code{SimParam$addTraitAD()}}
\item \href{#method-SimParam-altAddTraitAD}{\code{SimParam$altAddTraitAD()}}
\item \href{#method-SimParam-addTraitAG}{\code{SimParam$addTraitAG()}}
\item \href{#method-SimParam-addTraitADG}{\code{SimParam$addTraitADG()}}
\item \href{#method-SimParam-addTraitAE}{\code{SimParam$addTraitAE()}}
\item \href{#method-SimParam-addTraitADE}{\code{SimParam$addTraitADE()}}
\item \href{#method-SimParam-addTraitAEG}{\code{SimParam$addTraitAEG()}}
\item \href{#method-SimParam-addTraitADEG}{\code{SimParam$addTraitADEG()}}
\item \href{#method-SimParam-manAddTrait}{\code{SimParam$manAddTrait()}}
\item \href{#method-SimParam-importTrait}{\code{SimParam$importTrait()}}
\item \href{#method-SimParam-switchTrait}{\code{SimParam$switchTrait()}}
\item \href{#method-SimParam-removeTrait}{\code{SimParam$removeTrait()}}
\item \href{#method-SimParam-setVarE}{\code{SimParam$setVarE()}}
\item \href{#method-SimParam-setCorE}{\code{SimParam$setCorE()}}
\item \href{#method-SimParam-rescaleTraits}{\code{SimParam$rescaleTraits()}}
\item \href{#method-SimParam-setRecombRatio}{\code{SimParam$setRecombRatio()}}
\item \href{#method-SimParam-switchGenMap}{\code{SimParam$switchGenMap()}}
\item \href{#method-SimParam-switchFemaleMap}{\code{SimParam$switchFemaleMap()}}
\item \href{#method-SimParam-switchMaleMap}{\code{SimParam$switchMaleMap()}}
\item \href{#method-SimParam-addToRec}{\code{SimParam$addToRec()}}
\item \href{#method-SimParam-ibdHaplo}{\code{SimParam$ibdHaplo()}}
\item \href{#method-SimParam-updateLastId}{\code{SimParam$updateLastId()}}
\item \href{#method-SimParam-addToPed}{\code{SimParam$addToPed()}}
\item \href{#method-SimParam-clone}{\code{SimParam$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-new"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-new}{}}}
\subsection{Method \code{new()}}{
Starts the process of building a new simulation
by creating a new SimParam object and assigning a founder
population to the class. It is recommended that you save the
object with the name "SP", because subsequent functions will
check your global environment for an object of this name if
their simParam arguments are NULL. This allows you to call
these functions without explicitly supplying a simParam
argument with every call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$new(founderPop)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{founderPop}}{an object of \code{\link{MapPop-class}}}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setTrackPed"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setTrackPed}{}}}
\subsection{Method \code{setTrackPed()}}{
Sets pedigree tracking for the simulation.
By default pedigree tracking is turned off. When turned on,
the pedigree of all individuals created will be tracked,
except those created by \code{\link{hybridCross}}. Turning
off pedigree tracking will turn off recombination tracking
if it is turned on.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setTrackPed(isTrackPed, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isTrackPed}}{should pedigree tracking be on.}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setTrackPed(TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setTrackRec"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setTrackRec}{}}}
\subsection{Method \code{setTrackRec()}}{
Sets recombination tracking for the simulation.
By default recombination tracking is turned off. When turned
on recombination tracking will also turn on pedigree tracking.
Recombination tracking keeps records of all individuals created,
except those created by \code{\link{hybridCross}}, because their
pedigree is not tracked.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setTrackRec(isTrackRec, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isTrackRec}}{should recombination tracking be on.}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setTrackRec(TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-resetPed"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-resetPed}{}}}
\subsection{Method \code{resetPed()}}{
Resets the internal lastId, the pedigree
and recombination tracking (if in use) to the
supplied lastId. Be careful using this function because
it may introduce a bug if you use individuals from
the deleted portion of the pedigree.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$resetPed(lastId = 0L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{last ID to include in pedigree}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}

#Create population
pop = newPop(founderPop, simParam=SP)
pop@id # 1:10

#Create another population after reseting pedigree
SP$resetPed()
pop2 = newPop(founderPop, simParam=SP)
pop2@id # 1:10
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-restrSegSites"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-restrSegSites}{}}}
\subsection{Method \code{restrSegSites()}}{
Sets restrictions on which segregating sites
can serve as a SNP and/or QTL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$restrSegSites(
  minQtlPerChr = NULL,
  minSnpPerChr = NULL,
  excludeQtl = NULL,
  excludeSnp = NULL,
  overlap = FALSE,
  minSnpFreq = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minQtlPerChr}}{the minimum number of segregating sites for 
QTLs. Can be a single value or a vector values for each chromosome.}

\item{\code{minSnpPerChr}}{the minimum number of segregating sites for SNPs.
Can be a single value or a vector values for each chromosome.}

\item{\code{excludeQtl}}{an optional vector of segregating site names to 
exclude from consideration as a viable QTL.}

\item{\code{excludeSnp}}{an optional vector of segregating site names to 
exclude from consideration as a viable SNP.}

\item{\code{overlap}}{should SNP and QTL sites be allowed to overlap.}

\item{\code{minSnpFreq}}{minimum allowable frequency for SNP loci.
No minimum SNP frequency is used if value is NULL.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$restrSegSites(minQtlPerChr=5, minSnpPerChr=5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setSexes"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setSexes}{}}}
\subsection{Method \code{setSexes()}}{
Changes how sexes are determined in the simulation.
The default sexes is "no", indicating all individuals are hermaphrodites.
To add sexes to the simulation, run this function with "yes_sys" or
"yes_rand". The value "yes_sys" will systematically assign
sexes to newly created individuals as first male and then female.
Populations with an odd number of individuals will have one more male than
female. The value "yes_rand" will randomly assign a sex to each
individual.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setSexes(sexes, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sexes}}{acceptable value are "no", "yes_sys", or
"yes_rand"}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setSexes("yes_sys")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setFounderHap"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setFounderHap}{}}}
\subsection{Method \code{setFounderHap()}}{
Allows for the manual setting of founder haplotypes. This functionality 
is not fully documented, because it is still experimental.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setFounderHap(hapMap)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hapMap}}{a list of founder haplotypes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addSnpChip"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addSnpChip}{}}}
\subsection{Method \code{addSnpChip()}}{
Randomly assigns eligible SNPs to a SNP chip
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addSnpChip(nSnpPerChr, minSnpFreq = NULL, refPop = NULL, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nSnpPerChr}}{number of SNPs per chromosome.
Can be a single value or nChr values.}

\item{\code{minSnpFreq}}{minimum allowable frequency for SNP loci.
If NULL, no minimum frequency is used.}

\item{\code{refPop}}{reference population for calculating SNP
frequency. If NULL, the founder population is used.}

\item{\code{name}}{optional name for chip}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addSnpChip(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addSnpChipByName"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addSnpChipByName}{}}}
\subsection{Method \code{addSnpChipByName()}}{
Assigns SNPs to a SNP chip by supplying marker names. This function does 
check against excluded SNPs and will not add the SNPs to the list of 
excluded QTL for the purpose of avoiding overlap between SNPs and QTL. 
Excluding these SNPs from being used as QTL can be accomplished using 
the excludeQtl argument in SimParam's restrSegSites function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addSnpChipByName(markers, name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{markers}}{a vector of names for the markers}

\item{\code{name}}{optional name for chip}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addSnpChipByName(c("1_1","1_3"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addStructuredSnpChip"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addStructuredSnpChip}{}}}
\subsection{Method \code{addStructuredSnpChip()}}{
Randomly selects the number of snps in structure and then
assigns them to chips based on structure
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addStructuredSnpChip(nSnpPerChr, structure, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nSnpPerChr}}{number of SNPs per chromosome.
Can be a single value or nChr values.}

\item{\code{structure}}{a matrix.  Rows are snp chips, columns are chips.
If value is true then that snp is on that chip.}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitA"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitA}{}}}
\subsection{Method \code{addTraitA()}}{
Randomly assigns eligible QTLs for one or more additive traits.
If simulating more than one trait, all traits will be pleiotropic
with correlated additive effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitA(
  nQtlPerChr,
  mean = 0,
  var = 1,
  corA = NULL,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitAD"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitAD}{}}}
\subsection{Method \code{addTraitAD()}}{
Randomly assigns eligible QTLs for one or more traits with dominance.
If simulating more than one trait, all traits will be pleiotropic
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAD(
  nQtlPerChr,
  mean = 0,
  var = 1,
  meanDD = 0,
  varDD = 0,
  corA = NULL,
  corDD = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAD(10, meanDD=0.5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-altAddTraitAD"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-altAddTraitAD}{}}}
\subsection{Method \code{altAddTraitAD()}}{
An alternative method for adding a trait with additive  and dominance effects 
to an AlphaSimR simulation. The function attempts to create a trait matching 
user defined values for number of QTL, inbreeding depression, additive genetic 
variance and dominance genetic variance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$altAddTraitAD(
  nQtlPerChr,
  mean = 0,
  varA = 1,
  varD = 0,
  inbrDepr = 0,
  limMeanDD = c(0, 1.5),
  limVarDD = c(0, 0.5),
  silent = FALSE,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. 
Can be a single value or nChr values.}

\item{\code{mean}}{desired mean of the trait}

\item{\code{varA}}{desired additive variance}

\item{\code{varD}}{desired dominance variance}

\item{\code{inbrDepr}}{desired inbreeding depression, see details}

\item{\code{limMeanDD}}{limits for meanDD, see details}

\item{\code{limVarDD}}{limits for varDD, see details}

\item{\code{silent}}{should summary details be printed to the console}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function will always add a trait to 'SimParam', unless an error occurs 
with picking QTLs. The resulting trait will always have the desired mean and 
additive genetic variance. However, it may not have the desired values for 
inbreeding depression and dominance variance. Thus, it is strongly recommended 
to check the output printed to the console to determine how close the trait's 
parameters came to these desired values.

The mean and additive genetic variance will always be achieved exactly. The 
function attempts to achieve the desired dominance variance and inbreeding 
depression while staying within the user supplied constraints for the 
acceptable range of dominance degree mean and variance. If the desired values
are not being achieved, the acceptable range need to be increased and/or the 
number of QTL may need to be increased. There are not limits to setting the 
range for dominance degree mean and variance, but care should be taken to 
with regards to the biological feasibility of the limits that are supplied. 
The default limits were somewhat arbitrarily set, so I make not claim to 
how reasonable these limits are for routine use.

Inbreeding depression in this function is defined as the difference in mean 
genetic value between a population with the same allele frequency as the 
reference population (population used to initialize SimParam) in 
Hardy-Weinberg equilibrium compared to a population with the same allele 
frequency that is fully inbred. This is equivalent to the amount the mean of 
a population increases when going from an inbreeding coefficient of 1 (fully 
inbred) to a population with an inbreeding coefficient of 0 (Hardy-Weinberg 
equilibrium). Note that the sign of the value should (usually) be positive. 
This corresponds to a detrimental effect of inbreeding when higher values of 
the trait are considered biologically beneficial.

Summary information on this trait is printed to the console when silent=FALSE. 
The summary information reports the inbreeding depression and dominance 
variance for the population as well as the dominance degree mean and variance 
applied to the trait.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$altAddTraitAD(nQtlPerChr=10, mean=0, varA=1, varD=0.05, inbrDepr=0.2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitAG"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitAG}{}}}
\subsection{Method \code{addTraitAG()}}{
Randomly assigns eligible QTLs for one or more additive GxE traits.
If simulating more than one trait, all traits will be pleiotropic
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varGxE = 1e-06,
  varEnv = 0,
  corA = NULL,
  corGxE = NULL,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAG(10, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitADG"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitADG}{}}}
\subsection{Method \code{addTraitADG()}}{
Randomly assigns eligible QTLs for a trait with dominance and GxE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varEnv = 0,
  varGxE = 1e-06,
  meanDD = 0,
  varDD = 0,
  corA = NULL,
  corDD = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single
value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitADG(10, meanDD=0.5, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitAE"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitAE}{}}}
\subsection{Method \code{addTraitAE()}}{
Randomly assigns eligible QTLs for one or more additive and epistasis
traits. If simulating more than one trait, all traits will be pleiotropic
with correlated additive effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAE(
  nQtlPerChr,
  mean = 0,
  var = 1,
  relAA = 0,
  corA = NULL,
  corAA = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAE(10, relAA=0.1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitADE"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitADE}{}}}
\subsection{Method \code{addTraitADE()}}{
Randomly assigns eligible QTLs for one or more traits with dominance and
epistasis. If simulating more than one trait, all traits will be pleiotropic
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADE(
  nQtlPerChr,
  mean = 0,
  var = 1,
  meanDD = 0,
  varDD = 0,
  relAA = 0,
  corA = NULL,
  corDD = NULL,
  corAA = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitADE(10)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitAEG"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitAEG}{}}}
\subsection{Method \code{addTraitAEG()}}{
Randomly assigns eligible QTLs for one or more additive and epistasis
GxE traits. If simulating more than one trait, all traits will be pleiotropic
with correlated effects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitAEG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  relAA = 0,
  varGxE = 1e-06,
  varEnv = 0,
  corA = NULL,
  corAA = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true. If
FALSE, tuning is performed according to total genetic variance.}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitAEG(10, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addTraitADEG"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addTraitADEG}{}}}
\subsection{Method \code{addTraitADEG()}}{
Randomly assigns eligible QTLs for a trait with dominance,
epistasis and GxE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addTraitADEG(
  nQtlPerChr,
  mean = 0,
  var = 1,
  varEnv = 0,
  varGxE = 1e-06,
  meanDD = 0,
  varDD = 0,
  relAA = 0,
  corA = NULL,
  corDD = NULL,
  corAA = NULL,
  corGxE = NULL,
  useVarA = TRUE,
  gamma = FALSE,
  shape = 1,
  force = FALSE,
  name = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nQtlPerChr}}{number of QTLs per chromosome. Can be a single
value or nChr values.}

\item{\code{mean}}{a vector of desired mean genetic values for one or more traits}

\item{\code{var}}{a vector of desired genetic variances for one or more traits}

\item{\code{varEnv}}{a vector of environmental variances for one or more traits}

\item{\code{varGxE}}{a vector of total genotype-by-environment variances for the traits}

\item{\code{meanDD}}{mean dominance degree}

\item{\code{varDD}}{variance of dominance degree}

\item{\code{relAA}}{the relative value of additive-by-additive variance compared
to additive variance in a diploid organism with allele frequency 0.5}

\item{\code{corA}}{a matrix of correlations between additive effects}

\item{\code{corDD}}{a matrix of correlations between dominance degrees}

\item{\code{corAA}}{a matrix of correlations between additive-by-additive effects}

\item{\code{corGxE}}{a matrix of correlations between GxE effects}

\item{\code{useVarA}}{tune according to additive genetic variance if true}

\item{\code{gamma}}{should a gamma distribution be used instead of normal}

\item{\code{shape}}{the shape parameter for the gamma distribution
(the rate/scale parameter of the gamma distribution is accounted
for via the desired level of genetic variance, the var argument)}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing.}

\item{\code{name}}{optional name for trait(s)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitADEG(10, meanDD=0.5, varGxE=2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-manAddTrait"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-manAddTrait}{}}}
\subsection{Method \code{manAddTrait()}}{
Manually add a new trait to the simulation. Trait must
be formatted as a \code{\link{LociMap-class}}. If the
trait is not already formatted, consider using importTrait.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$manAddTrait(lociMap, varE = NA_real_, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lociMap}}{a new object descended from
\code{\link{LociMap-class}}}

\item{\code{varE}}{default error variance for phenotype, optional}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-importTrait"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-importTrait}{}}}
\subsection{Method \code{importTrait()}}{
Manually add a new trait(s) to the simulation. Unlike the
manAddTrait function, this function does not require
formatting the trait as a \code{\link{LociMap-class}}.
The formatting is performed automatically for the user,
with more user friendly data.frames or matrices taken as
inputs. This function only works for A and AD trait types.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$importTrait(
  markerNames,
  addEff,
  domEff = NULL,
  intercept = NULL,
  name = NULL,
  varE = NULL,
  force = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{markerNames}}{a vector of names for the QTL}

\item{\code{addEff}}{a matrix of additive effects (nLoci x nTraits).
Alternatively, a vector of length nLoci can be supplied for
a single trait.}

\item{\code{domEff}}{optional dominance effects for each locus}

\item{\code{intercept}}{optional intercepts for each trait}

\item{\code{name}}{optional name(s) for the trait(s)}

\item{\code{varE}}{default error variance for phenotype, optional}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-switchTrait"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-switchTrait}{}}}
\subsection{Method \code{switchTrait()}}{
Switch a trait in the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchTrait(traitPos, lociMap, varE = NA_real_, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{traitPos}}{an integer indicate which trait to switch}

\item{\code{lociMap}}{a new object descended from
\code{\link{LociMap-class}}}

\item{\code{varE}}{default error variance for phenotype, optional}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-removeTrait"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-removeTrait}{}}}
\subsection{Method \code{removeTrait()}}{
Remove a trait from the simulation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$removeTrait(traits, force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{traits}}{an integer vector indicating which traits to remove}

\item{\code{force}}{should the check for a running simulation be
ignored. Only set to TRUE if you know what you are doing}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setVarE"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setVarE}{}}}
\subsection{Method \code{setVarE()}}{
Defines a default values for error
variances used in \code{\link{setPheno}}. These defaults 
will be used to automatically generate phenotypes when new 
populations are created. See the details section of \code{\link{setPheno}}
for more information about each arguments and how they 
should be used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setVarE(h2 = NULL, H2 = NULL, varE = NULL, corE = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{h2}}{a vector of desired narrow-sense heritabilities}

\item{\code{H2}}{a vector of desired broad-sense heritabilities}

\item{\code{varE}}{a vector or matrix of error variances}

\item{\code{corE}}{an optional matrix of error correlations}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
SP$setVarE(h2=0.5)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setCorE"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setCorE}{}}}
\subsection{Method \code{setCorE()}}{
Defines a correlation structure for default
error variances. You must call \code{setVarE} first to define
the default error variances.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setCorE(corE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{corE}}{a correlation matrix for the error variances}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10, mean=c(0,0), var=c(1,1), corA=diag(2))
SP$setVarE(varE=c(1,1))
E = 0.5*diag(2)+0.5 #Positively correlated error
SP$setCorE(E)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-rescaleTraits"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-rescaleTraits}{}}}
\subsection{Method \code{rescaleTraits()}}{
Linearly scales all traits to achieve desired
values of means and variances in the founder population.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$rescaleTraits(
  mean = 0,
  var = 1,
  varEnv = 0,
  varGxE = 1e-06,
  useVarA = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mean}}{a vector of new trait means}

\item{\code{var}}{a vector of new trait variances}

\item{\code{varEnv}}{a vector of new environmental variances}

\item{\code{varGxE}}{a vector of new GxE variances}

\item{\code{useVarA}}{tune according to additive genetic variance if true}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)
meanG(pop)

#Change mean to 1
SP$rescaleTraits(mean=1)
\dontshow{SP$nThreads = 1L}
#Run resetPop for change to take effect
pop = resetPop(pop, simParam=SP)
meanG(pop)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-setRecombRatio"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-setRecombRatio}{}}}
\subsection{Method \code{setRecombRatio()}}{
Set the relative recombination rates between males
and females. This allows for sex-specific recombination rates,
under the assumption of equivalent recombination landscapes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$setRecombRatio(femaleRatio)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{femaleRatio}}{relative ratio of recombination in females compared to
males. A value of 2 indicate twice as much recombination in females. The
value must be greater than 0. (default is 1)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$setRecombRatio(2) #Twice as much recombination in females
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-switchGenMap"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-switchGenMap}{}}}
\subsection{Method \code{switchGenMap()}}{
Replaces existing genetic map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchGenMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genMap}}{a list of length nChr containing
numeric vectors for the position of each segregating
site on a chromosome.}

\item{\code{centromere}}{a numeric vector of centromere
positions. If NULL, the centromere are assumed to
be metacentric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-switchFemaleMap"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-switchFemaleMap}{}}}
\subsection{Method \code{switchFemaleMap()}}{
Replaces existing female genetic map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchFemaleMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genMap}}{a list of length nChr containing
numeric vectors for the position of each segregating
site on a chromosome.}

\item{\code{centromere}}{a numeric vector of centromere
positions. If NULL, the centromere are assumed to
be metacentric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-switchMaleMap"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-switchMaleMap}{}}}
\subsection{Method \code{switchMaleMap()}}{
Replaces existing male genetic map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$switchMaleMap(genMap, centromere = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{genMap}}{a list of length nChr containing
numeric vectors for the position of each segregating
site on a chromosome.}

\item{\code{centromere}}{a numeric vector of centromere
positions. If NULL, the centromere are assumed to
be metacentric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addToRec"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addToRec}{}}}
\subsection{Method \code{addToRec()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addToRec(lastId, id, mother, father, isDH, hist, ploidy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{ID of last individual}

\item{\code{id}}{the name of each individual}

\item{\code{mother}}{vector of mother iids}

\item{\code{father}}{vector of father iids}

\item{\code{isDH}}{indicator for DH lines}

\item{\code{hist}}{new recombination history}

\item{\code{ploidy}}{ploidy level}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-ibdHaplo"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-ibdHaplo}{}}}
\subsection{Method \code{ibdHaplo()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$ibdHaplo(iid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iid}}{internal ID}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-updateLastId"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-updateLastId}{}}}
\subsection{Method \code{updateLastId()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$updateLastId(lastId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{last ID assigned}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-addToPed"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-addToPed}{}}}
\subsection{Method \code{addToPed()}}{
For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$addToPed(lastId, id, mother, father, isDH)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lastId}}{ID of last individual}

\item{\code{id}}{the name of each individual}

\item{\code{mother}}{vector of mother iids}

\item{\code{father}}{vector of father iids}

\item{\code{isDH}}{indicator for DH lines}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SimParam-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SimParam-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimParam$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
