% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{rawToAmigaBasicBMAP}
\alias{rawToAmigaBasicBMAP}
\title{Coerce raw data into an AmigaBasicBMAP class object}
\usage{
rawToAmigaBasicBMAP(x, ...)
}
\arguments{
\item{x}{A \code{vector} of \code{raw} data that is to be converted
into an \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} class object.}

\item{...}{Currently ignored.}
}
\value{
An \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} class object based on \code{x}.
}
\description{
Coerce raw data into an \code{\link[=AmigaBasicBMAP]{AmigaBasicBMAP()}} class object
}
\details{
An \link[=AmigaBasicBMAP]{Amiga Basic BMAP} file maps the offset of routines in Amiga libraries. This
function converts the raw format in which it would be stored as a file into a comprehensive S3 class object.
}
\examples{
## A small fragment of the dos.library BMAP would look like this:
dos.bmap <- as.AmigaBasicBMAP(list(
  xOpen = list(
    libraryVectorOffset = -30,
    registers = as.raw(2:3)
  ),
  xClose = list(
    libraryVectorOffset = -36,
    registers = as.raw(2)
  ),
  xRead = list(
    libraryVectorOffset = -42,
    registers = as.raw(2:4)
  )
))

## The raw representation would be
dos.bmap.raw <- as.raw(dos.bmap)

## And the reverse
rawToAmigaBasicBMAP(dos.bmap.raw)
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{write.AmigaBasic}()}

Other raw.operations: 
\code{\link{as.AmigaBasic}()},
\code{\link{as.raw.AmigaBasic}()},
\code{\link{colourToAmigaRaw}()},
\code{\link{packBitmap}()},
\code{\link{rawToAmigaBasicShape}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaIcon}()},
\code{\link{rawToHWSprite}()},
\code{\link{rawToIFFChunk}()},
\code{\link{rawToSysConfig}()},
\code{\link{simpleAmigaIcon}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
\concept{raw.operations}
