% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportCSV.R
\name{ImportCSV}
\alias{ImportCSV}
\title{Importing a CSV file}
\usage{
ImportCSV(
  file,
  dec = ".",
  sep = ",",
  comment.char = "#",
  header = TRUE,
  iterationColumn = NULL,
  referenceYear = NULL,
  rowToWithdraw = NULL,
  bin.width = NULL
)
}
\arguments{
\item{file}{Name of the CSV file containing the output of the MCMC algorithm.}

\item{dec}{Character used in the file for decimal points for the use of \code{read.csv()}.}

\item{sep}{Field separator character for the use of \code{read.csv()}.}

\item{comment.char}{Character vector of length one containing a single
character or an empty string for the use of \code{read.csv()}.}

\item{header}{Logical value indicating whether the file contains the names
of the variables as its first line.}

\item{iterationColumn}{Column number corresponding to the iteration values,
default = \code{NULL}.}

\item{referenceYear}{Year of reference for MCMC in date format other than
BC/AD, default = \code{NULL}.}

\item{rowToWithdraw}{Number of the row to be withdrawn or "last" for the
last row of the data frame, default = \code{NULL}.}

\item{bin.width}{Bin width specified in a BCal project (note that \code{bin.width}
does not have to be set if the BCal default bin width of 1 is used).}
}
\value{
A data frame containing a representation of the data in the file.
}
\description{
Import a CSV file containing the output of the MCMC algorithm
}
\details{
Use of the \code{read.csv()} function with default values for CSV files produced by
\href{https://chronomodel.com}{ChronoModel} software. For MCMC in a date format
different from BC/AD, use the
parameter \code{referenceYear} to convert the MCMC to BC/AD, otherwise the
remaining functions of \pkg{ArchaeoPhases} will not work. MCMC files generated by
\href{https://bcal.shef.ac.uk/top.html}{BCal} may contain an empty last row. This row
should be withdrawn using the \code{rowToWithdraw} parameter.
Otherwise, the functions of \pkg{ArchaeoPhases} will not work properly.
}
\examples{

  data(Events)
\dontrun{
  write.csv(Events, "data.csv", row.names=FALSE)
  data = ImportCSV("data.csv", dec = '.', sep=',', comment.char='#',
                   header = TRUE, iterationColumn = 1)

  # Import of MCMC generated by BCal and extracted in cal BP
  # (the year of reference is 1950)
  if (requireNamespace("ArchaeoPhases.dataset", quietly = TRUE)) {
  data(Fishpond)
  write.csv(Fishpond, "fishpond_MCMC.csv", row.names=FALSE)
  Fishpond = ImportCSV("fishpond_MCMC.csv", dec = '.', sep=',',
                       header = TRUE, iterationColumn = 1,
                       referenceYear = 1950, rowToWithdraw = "last")}
}


}
\seealso{
\code{\link{ImportCSV.BCal}}

\code{\link{read_chronomodel}}

\code{\link{read_oxcal}}
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr},

Thomas S. Dye, \email{tsd@tsdye.online}, and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
