% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPT_main.R
\name{npt}
\alias{npt}
\title{Nonparametric trend test based on the nonparametric
risk under a given genetic model}
\usage{
npt(y, g, varphi)
}
\arguments{
\item{y}{a numeric vector of the observed quantitative trait
values in which the \emph{i}th element corresponds to the trait
value of the \emph{i}th subject.}

\item{g}{a numeric vector of the observed genotype values (\code{0}, \code{1},
or \code{2} denotes the number of risk alleles) in which the \emph{i}th
element is the genotype value of the \emph{i}th subject for a
biallelic SNP. \code{g} has the same length as \code{y}.}

\item{varphi}{a numeric value which represents the genetic
model. It should be \code{0}, \code{0.5}, or \code{1}, which indicates that the
calculation is performed under the recessive, additive, or
dominant model, respectively.}
}
\value{
A list with class "\code{htest}" containing the following components:
\tabular{llll}{
\code{statistic} \tab \tab \tab \cr
\tab \tab \tab the observed value of the test statistic.\cr
\code{p.value} \tab \tab \tab \cr
\tab \tab \tab the p-value for the test.\cr
\code{alternative} \tab \tab \tab \cr
\tab \tab \tab a character string describing the alternative hypothesis.\cr
\code{method} \tab \tab \tab \cr
\tab \tab \tab a character string indicating the type of test performed.\cr
\code{data.name} \tab \tab \tab \cr
\tab \tab \tab a character string giving the names of the data.
}
}
\description{
Test for the association between a genetic variant and a
non-normal distributed quantitative trait based on the
nonparametric risk under a specific genetic model.
}
\details{
For a non-normal distributed quantitative trait, three genetic
models (recessive, additive and dominant) used commonly are
defined in terms of the nonparametric risk (NR). The recessive,
additive, and dominant models can be classified based on the
nonparametric risks. More specifically, the recessive, additive,
and dominant models refer to NR20 > NR10 = 1/2, NR12 = NR10>1/2, and
NR10 = NR20 > 1/2, respectively, where NR10 and NR20 are the
nonparametric risks of the groups with the genotypes 1 and 2
relative to the group with the genotype 0, respectively, and NR12
is the nonparametric risk of the group with the genotype 2
relative to the group with the genotype 1.

\code{varphi} can be \code{0}, \code{0.5}, or \code{1} for the recessive, additive, or
dominant model, respectively. When \code{varphi} is \code{0}, the test is
constructed under the recessive model by pooling together the
subjects with the genotypes 0 and 1. Similarly, when \code{varphi}
is \code{1}, the test is constructed under the dominant model by pooling
together the subjects with the genotypes 1 and 2. When
\code{varphi} is \code{0.5}, the test is based on the weighted sum of
NR10 and NR12.
}
\examples{
g <- rbinom(1500, 2, 0.3)
y <- 0.5 + 0.25 * g + rgev(1500, 0, 0, 5)
npt(y, g, 0.5)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
