\name{asynchDataTI}
\docType{data}
\alias{asynchDataTI}
\alias{TI.x}
\alias{TI.y}
\title{
Generated Asynchronous Longitudinal Data with Time-Invariant Coefficients
}
\description{
For the purposes of the package examples, the
 data set was adapted from the numerical simulations of the original
manuscript. Specifically, data was generated for 400 subjects.
The number of observation times for the response was Poisson distributed
with intensity rate 5, and similarly for the number of observation times
for the covariates. Observation times are generated from a uniform
distribution Unif(0,1) independently. The covariate process is
Gaussian, with values at fixed time points being multivariate normal
with mean 0, variance 1 and correlation exp(-|t_{ij} - t_{ik}|).
The responses were generated from Y(t) = beta0 + X(t)*beta1 + epsilon(t),
where beta0 = 0.5, beta1 = 1.5, and epsilon(t) is Gaussian with
mean 0, variance 1 and cov(e(s),e(t)) = 2^{-|t-s|}.
Covariates are stored as TI.x. Responses are stored as
TI.y.
}
\format{
TI.x is a data frame with 2014 observations on the following 3 variables.
\describe{
\item{\code{ID}}{patient identifier, there are 400 patients.}
\item{\code{t}}{the covariate observation times}
\item{\code{X1}}{the covariate measured at observation time t}
}
TI.y is a data frame with 2101 observations on the following 3 variables.
\describe{
\item{\code{ID}}{patient identifier, there are 400 patients.}
\item{\code{t}}{the response observation times.}
\item{\code{Y}}{the response measured at time t.}
}
}
\usage{
asynchDataTI
}
\source{
Generated by Shannon T. Holloway in R.
}
\references{
Cao, H., Zeng, D., and Fine, J. P. (2015)
Regression Analysis of sparse asynchronous longitudinal data.
Journal of the Royal Statistical Society: Series B, 77, 755-776.
}
\keyword{datasets }
